package com.mmc.pms.service;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.model.order.dto.OrderGoodsIndstDTO;
import com.mmc.pms.model.order.dto.OrderGoodsProdDTO;
import com.mmc.pms.model.qo.MallOrderGoodsInfoQO;
import com.mmc.pms.model.qo.ProductSpecPriceQO;
import com.mmc.pms.model.sale.dto.MallGoodsShopCarDTO;
import com.mmc.pms.model.sale.dto.MallProductSpecPriceDTO;
import com.mmc.pms.model.sale.dto.ProductSpecPriceDTO;
import com.mmc.pms.model.sale.qo.MallGoodsQO;
import com.mmc.pms.model.sale.vo.GoodsAddVO;
import com.mmc.pms.page.PageResult;

import java.util.List;

/**
 * @author 23214
 * @description 针对表【goods_info(商品基本信息)】的数据库操作Service
 * @createDate 2023-05-27 14:08:45
 */
public interface GoodsInfoService {

  ResultBody addGoods(GoodsAddVO goodsAddVO);

  ResultBody editGoodsInfo(GoodsAddVO goodsAddVO);

  ResultBody getGoodsInfoDetail(Integer goodsInfoId);

  ResultBody getSkuUnit();

  ResultBody getSaleServiceInfoToList();

  List<MallGoodsShopCarDTO> fillGoodsInfo(List<MallGoodsShopCarDTO> param);

  List<MallProductSpecPriceDTO> feignListProductSpecPrice(ProductSpecPriceQO productSpecPriceQO);

  ProductSpecPriceDTO feignGetUnitPriceByTag(Integer specId, Integer tagId);

  List<OrderGoodsProdDTO> feignListProdGoodsSkuInfo(MallOrderGoodsInfoQO mallOrderGoodsInfoQO);

  List<OrderGoodsIndstDTO> feignListIndstGoodsSkuInfo(MallOrderGoodsInfoQO mallOrderGoodsInfoQO);

  PageResult listPageGoodsInfo(MallGoodsQO param);
}
