package com.mmc.pms.entity;

import com.mmc.pms.model.categories.dto.CategoriesInfoListDTO;
import com.mmc.pms.model.categories.dto.ClassifyDetailsDTO;
import com.mmc.pms.model.categories.dto.ClassifyInfoDTO;
import com.mmc.pms.model.categories.vo.ClassifyInfoVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lw @TableName categories
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class Categories implements Serializable {
  private Integer id;

  private Integer parentId;

  private String name;

  private String icon;

  private String description;

  private Integer sort;

  private Integer type;

  private Date createTime;

  private Date updateTime;

  private Integer deleted;
  private Integer directoryId;
  private String remark;

  public Categories(ClassifyInfoVO classifyInfoVO) {
    this.id = classifyInfoVO.getId();
    this.parentId = classifyInfoVO.getPid();
    this.name = classifyInfoVO.getClassifyName();
    this.icon = classifyInfoVO.getIcon();
    this.description = classifyInfoVO.getDescription();
    this.type = classifyInfoVO.getType();
    this.directoryId = classifyInfoVO.getDirectoryId();
    this.remark = classifyInfoVO.getRemark();
  }

  public ClassifyInfoDTO buildClassifyInfoDTO() {
    return ClassifyInfoDTO.builder()
        .id(id)
        .description(description)
        .icon(icon)
        .pid(parentId)
        .classifyName(name)
        .remark(remark)
        .createTime(createTime)
        .directoryId(directoryId)
        .type(type)
        .build();
  }

  public ClassifyDetailsDTO buildClassifyDetailsDTO() {
    return ClassifyDetailsDTO.builder()
        .id(id)
        .description(description)
        .icon(icon)
        .classifyName(name)
        .remark(remark)
        .build();
  }

  public CategoriesInfoListDTO buildCategoriesInfoListDTO() {
    return CategoriesInfoListDTO.builder().id(id).icon(icon).name(name).build();
  }
}
