package com.mmc.pms.dao;

import com.mmc.pms.entity.*;
import com.mmc.pms.model.sale.qo.MallGoodsQO;
import com.mmc.pms.model.sale.vo.GoodsAddVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;

/**
 * @author 23214
 * @description 针对表【goods_info(商品基本信息)】的数据库操作Mapper
 * @createDate 2023-05-27 14:08:45 @Entity com.mmc.pms.entity.GoodsInfo
 */
@Mapper
public interface GoodsInfoDao {

  int countGoodsInfoByName(GoodsAddVO goodsAddVO);

  void insertGoodsInfo(GoodsInfo goodsInfo);

  int countGoodsInfo();

  void insertGoodsImgInfo(List<GoodsImgDO> list);

  void insertVideoInfo(GoodsVideoDO goodsVideoDO);

  void insertGoodsDetail(GoodsDetailDO goodsDetailDO);

  void insertGoodsService(List<GoodsServiceDO> otherList);

  int countGoodsInfoById(Integer id);

  void updateGoodsInfo(GoodsInfo goodsInfo);

  void updateGoodsDetail(GoodsDetailDO goodsDetailDO);

  List<GoodsImgDO> listGoodsInfoByGoodsId(Integer id);

  void deleteImgByIds(List<Integer> deleteIds);

  void deleteGoodsVideoById(Integer id);

  void deleteGoodsServiceByGoodsId(Integer id);

  void insertMallIndustrySkuInfo(MallIndustrySkuInfoDO mallIndustrySkuInfoDO);

  void insertMallIndustrySkuInfoSpec(MallIndustrySkuInfoSpecDO mallIndustrySkuInfoSpecDO);

  List<MallProdInfoDO> getMallProSkuInfo(Integer id);

  void batchUpdateMallProductSku(List<Integer> delIds);

  void batchUpdateMallProdSkuInfo(List<MallProdInfoDO> mallProdSkuInfoList);

  List<MallIndustrySkuInfoDO> getMallIndustrySkuInfo(Integer id);

  GoodsInfo getGoodsSimpleInfo(Integer goodsInfoId);

  GoodsDetailDO getGoodsDetailByGoodsId(Integer goodsInfoId);

  List<GoodsServiceDO> listGoodsServiceByGoodsId(Integer goodsInfoId);

  List<SkuUnitDO> getSkuUnit();

  List<GoodsInfo> listSimpleGoodsInfoByIds(@Param("ids") Set<Integer> ids);

  void insertMallProdSkuInfo(MallProdInfoDO mallProdSkuInfoDO);

  void insertMallProdSkuInfoSpec(MallProdSkuInfoSpecDO mallProdSkuInfoSpecDO);

  void batchUpdateMallProSpec(@Param("list") List<Integer> list, @Param("id") Integer id);

  List<MallProdSkuInfoSpecDO> listMallProdSpecInfo(List<Integer> mallSkuIds);

  void batchUpdateMallProdSpec(List<Integer> delSpecId);

  List<MallGoodsSpecInfoDO> listProdSpecInfo(@Param("prodIds") Set<Integer> prodIds);

  List<MallGoodsSpecInfoDO> listIndstSpecInfo(@Param("indstIds") Set<Integer> indstIds);

  List<GoodsServiceDO> listGoodsService(List<Integer> goodsIds);

  List<MallGoodsInfoSimpleDO> listMallGoodsIndstSimpleInfo(
      @Param("indstSkuSpecIds") Set<Integer> indstSkuSpecIds);

  List<Integer> listIndustrySpecIds(Set<Integer> mallIndstSkuSpecIds);

  List<MallGoodsProductDO> listIndustryProductList(List<Integer> industrySpecIds);

  List<GoodsInfo> ListGoodsInfoByCategoryId(Integer id);

  List<MallProdSkuInfoSpecDO> getMallProSkuInfoSpec(Integer goodsInfoId);

  List<MallProdSkuInfoSpecDO> listMallprodSpecById(List<Integer> goodsIds);

  List<SaleServiceDO> listSaleServiceInfo();

  int countListGoodsInfo(MallGoodsQO param);

  List<GoodsInfo> listGoodsInfo(MallGoodsQO param);
}
