package com.mmc.pms.model.sale.qo;

import com.mmc.pms.common.Page;
import com.mmc.pms.model.group.Freeze;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * @Author LW
 * @date 2022/3/22 9:44 概要：商品列表查询QO
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MallGoodsQO {
    @ApiModelProperty(value = "商品名称", example = "商品名称")
    private String goodsName;

    @ApiModelProperty(value = "商品类型 0:销售 1:租赁", example = "0")
    private Integer goodsType;

    @ApiModelProperty(value = "开始时间", example = "2023-06-09 00:00:00")
    private String startTime;

    @ApiModelProperty(value = "结束时间", example = "2023-06-11 23:59:59")
    private String endTime;

    @ApiModelProperty(value = "状态 0:下架（仓库中）1:上架", example = "1")
    private Integer status;

    @ApiModelProperty(value = "目录id", example = "1")
    private Integer directoryId;

    @ApiModelProperty(value = "页码", required = true, example = "1")
    @NotNull(
            message = "页码不能为空",
            groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;

    @ApiModelProperty(value = "每页显示数", required = true, example = "10")
    @NotNull(
            message = "每页显示数不能为空",
            groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}
