package com.mmc.pms.model.sale.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * author:zhenjie
 * Date:2022/10/11
 * time:14:54
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "小程序购物车列表DTO")
public class MallGoodsShopCarDTO implements Serializable {
    private static final long serialVersionUID = 766856809957374985L;
    @ApiModelProperty("id")
    private Integer id;
    @ApiModelProperty("用户id")
    private Integer mallUserId;
    @ApiModelProperty("商品id")
    private Integer goodsInfoId;
    @ApiModelProperty("购买数量")
    private Integer buyNum;
    @ApiModelProperty("0:待下单 1:已下单")
    private Integer saleStatus;
    @ApiModelProperty("推荐人id")
    private Integer recMallUserId;
    @ApiModelProperty("备注")
    private String remark;
    @ApiModelProperty("是否删除")
    private Integer deleted;
    @ApiModelProperty("生成时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    //区分产品或者行业
    @ApiModelProperty("区分产品或者行业")
    private Integer directoryId;
    @ApiModelProperty("商品名称")
    private String goodsName;
    @ApiModelProperty("商品主图")
    private String mainImg;
    @ApiModelProperty("状态：0:下架 1:上架")
    private Integer shelfStatus;
    @ApiModelProperty("商品产品规格信息")
    private List<MallSkuInfoSpecDTO> skuList;
}
