package com.mmc.pms.model.other.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author small @Date 2023/5/25 9:49 @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "现金流水DTO")
public class RepoCashDTO implements Serializable {
  private static final long serialVersionUID = 4569221850373256579L;

  @ApiModelProperty(value = "ID")
  private Integer id;

  @ApiModelProperty(value = "用户ID", hidden = true)
  private Integer repoAccountId;

  @ApiModelProperty(value = "用户UID", hidden = true)
  private String uid;

  @ApiModelProperty(value = "用户名", hidden = true)
  private String accountName;

  @ApiModelProperty(value = "订单ID", hidden = true)
  private Integer orderInfoId;

  @ApiModelProperty(value = "订单编号")
  private String orderNo;

  @ApiModelProperty(value = "skuID", hidden = true)
  private Integer skuInfoId;

  @ApiModelProperty(value = "sku标题", hidden = true)
  private String skuTitle;

  @ApiModelProperty(value = "商品ID", hidden = true)
  private Integer wareInfoId;

  @ApiModelProperty(value = "商品编号", hidden = true)
  private String wareNo;

  @ApiModelProperty(value = "商品标题")
  private String wareTitle;

  @ApiModelProperty(value = "流水编号")
  private String payNo;

  @ApiModelProperty(value = "流水类型:查字典")
  private Integer payMethod;

  @ApiModelProperty(value = "变动金额")
  private BigDecimal amtPaid;

  @ApiModelProperty(value = "当前余额")
  private BigDecimal cashAmt;

  @ApiModelProperty(value = "支付时间")
  private Date payTime;

  @ApiModelProperty(value = "退款流水编号")
  private String refundNo;

  @ApiModelProperty(value = "凭证")
  private List<String> voucher;

  @ApiModelProperty(value = "备注")
  private String remark;

  @ApiModelProperty(value = "操作人账号")
  private String opNo;

  @ApiModelProperty(value = "操作人姓名")
  private String opName;

  private Integer createUser;
}
