package com.mmc.pms.model.lease.vo;

import com.mmc.pms.model.group.Create;
import com.mmc.pms.model.group.Update;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @Author small @Date 2023/5/16 17:20 @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "新增/修改参数类")
public class WareSkuInfoVO implements Serializable {
    private static final long serialVersionUID = 7401232386069965527L;

    @ApiModelProperty(value = "sku的id")
    @NotNull(
            message = "sku的id不能为空",
            groups = {Update.class})
    private Integer id;

    @ApiModelProperty(value = "商品skuTitle名称")
    @NotEmpty(
            message = "商品skuTitle名称不能为空",
            groups = {Create.class})
    private String skuTitle;

    @ApiModelProperty(value = "出租押金")
    @NotNull(
            message = "出租押金不能为空",
            groups = {Create.class})
    @Min(
            value = 0,
            message = "出租押金不能小于0",
            groups = {Create.class, Update.class})
    @Max(
            value = 100000000,
            message = "出租押金不能大于100000000",
            groups = {Create.class, Update.class})
    private BigDecimal rentDeposit;

    @ApiModelProperty(value = "sku库存数量")
    @NotNull(
            message = "sku库存数量不能为空",
            groups = {Create.class})
    @Min(
            value = 0,
            message = "sku库存数量不能小于0",
            groups = {Create.class, Update.class})
    private Integer stockNum;

    @ApiModelProperty(value = "sku对应价格列表")
    @NotEmpty(
            message = "sku对应价格列表不能为空",
            groups = {Create.class})
    List<WareSkuPriceVO> wareSkuPriceVOList;
}
