package com.mmc.pms.controller.mall;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.controller.BaseController;
import com.mmc.pms.model.mall.GoodsListVO;
import com.mmc.pms.model.mall.MallGoodsVO;
import com.mmc.pms.service.mall.AppMallGoodsService;
import com.mmc.pms.service.mall.MallGoodsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * @Author LW
 * @date 2023/7/26 14:26
 * 概要：
 */
@RestController
@RequestMapping("/app/goods")
@Api(tags = {"V1.0.3-小程序商城商品-相关接口"})
public class AppMallGoodsController extends BaseController {
    @Resource
    private MallGoodsService mallGoodsService;
    @Resource
    private AppMallGoodsService appMallGoodsService;

    @ApiOperation(value = "小程序商品详情")
    @GetMapping("appMallGoodsDetails")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = MallGoodsVO.class)})
    public ResultBody<MallGoodsVO> appMallGoodsDetails(@RequestParam Integer id) {
        return mallGoodsService.mallGoodsDetails(id);
    }

    @ApiOperation(value = "查询品牌方的商品")
    @GetMapping("queryBrandGoods")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = MallGoodsVO.class)})
    public ResultBody<MallGoodsVO> queryBrandGoods(@RequestParam Integer userAccountId) {
        return appMallGoodsService.queryBrandGoods(userAccountId);
    }

    @ApiOperation(value = "根据子分类查询商品信息")
    @PostMapping("queryGoodsInfoByCategorySub")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = MallGoodsVO.class)})
    public ResultBody<MallGoodsVO> queryGoodsInfoByCategorySub(@RequestBody List<Integer> categorySubIds) {
        return appMallGoodsService.queryGoodsInfoByCategorySub(categorySubIds);
    }

    @ApiOperation(value = "品牌店铺列表")
    @PostMapping("brandStoreList")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = GoodsListVO.class)})
    public ResultBody<GoodsListVO> brandStoreList(@RequestBody List<Integer> userAccountIds) {
        return appMallGoodsService.brandStoreList(userAccountIds);
    }
}
