package com.mmc.pms.service.mall.impl;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.dao.category.CategoryDao;
import com.mmc.pms.dao.mall.AppMallGoodsDao;
import com.mmc.pms.dao.mall.MallGoodsDao;
import com.mmc.pms.entity.category.CategoryPrimaryDO;
import com.mmc.pms.entity.mall.MallGoodsDO;
import com.mmc.pms.entity.mall.PriceStockDO;
import com.mmc.pms.model.category.dto.CategoryPrimaryDTO;
import com.mmc.pms.model.mall.GoodsListVO;
import com.mmc.pms.model.mall.MallGoodsVO;
import com.mmc.pms.model.mall.RecommendVO;
import com.mmc.pms.model.mall.UavCartDTO;
import com.mmc.pms.model.qo.mall.PriceStockQO;
import com.mmc.pms.service.mall.AppMallGoodsService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Author LW
 * @date 2023/7/26 14:55
 * 概要：
 */
@Service
public class AppMallGoodsServiceImpl implements AppMallGoodsService {
    @Resource
    private AppMallGoodsDao appMallGoodsDao;
    @Resource
    private MallGoodsDao mallGoodsDao;
    @Resource
    private CategoryDao categoryDao;

    @Override
    public ResultBody<MallGoodsVO> queryBrandGoods(Integer userAccountId) {
        List<MallGoodsDO> mallGoodsList = appMallGoodsDao.queryGoodsInfo(userAccountId, null);
        return checkGoodsInfo(mallGoodsList);
    }


    @Override
    public ResultBody<MallGoodsVO> queryGoodsInfoByCategorySub(List<Integer> categorySubIds) {
        List<MallGoodsDO> mallGoodsList = appMallGoodsDao.queryGoodsInfo(null, categorySubIds);
        return checkGoodsInfo(mallGoodsList);
    }

    private ResultBody<MallGoodsVO> checkGoodsInfo(List<MallGoodsDO> mallGoodsList) {
        if (CollectionUtils.isNotEmpty(mallGoodsList)) {
            return ResultBody.success(mallGoodsList.stream().map(MallGoodsDO::buildListMallGoodsVO).collect(Collectors.toList()));
        }
        return ResultBody.success();
    }

    @Override
    public ResultBody<GoodsListVO> brandStoreList(List<Integer> userAccountIds) {
        List<GoodsListVO> goodsList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(userAccountIds)) {
            List<MallGoodsDO> mallGoodsDOList = appMallGoodsDao.brandStoreList(userAccountIds);
            List<MallGoodsVO> list = mallGoodsDOList.stream().map(MallGoodsDO::buildListMallGoodsVO).collect(Collectors.toList());
            Map<Integer, List<MallGoodsVO>> map = list.
                    stream().collect(Collectors.groupingBy(MallGoodsVO::getUserAccountId));
            for (Map.Entry<Integer, List<MallGoodsVO>> entry : map.entrySet()) {
                GoodsListVO goodsListVO = new GoodsListVO();
                goodsListVO.setUserAccountId(entry.getKey());
                goodsListVO.setMallGoodsVOList(entry.getValue());
                goodsList.add(goodsListVO);
            }
        }
        return ResultBody.success(goodsList);
    }

    @Override
    public List<UavCartDTO> listPriceStock(List<PriceStockQO> param) {
        // 根据商品id和规格套装查询
        List<MallGoodsDO> mallGoodsList = appMallGoodsDao.listPriceStock(param);
        List<UavCartDTO> uavCartDTOS = new ArrayList<UavCartDTO>();
        for (MallGoodsDO mallGoodsDO : mallGoodsList) {
            if (CollectionUtils.isNotEmpty(mallGoodsDO.getPriceStockDOS())) {
                for (PriceStockDO priceStockDO : mallGoodsDO.getPriceStockDOS()) {
                    UavCartDTO uavCartDTO = mallGoodsDO.buildUavCartDTO();
                    uavCartDTO.setSkuImage(StringUtils.isBlank(priceStockDO.getSkuImage()) ? mallGoodsDO.getUrl() : priceStockDO.getSkuImage());
                    uavCartDTO.setProductSpec(priceStockDO.getProductSpec());
                    uavCartDTO.setSalePrice(priceStockDO.getSalePrice());
                    uavCartDTO.setSkuNo(priceStockDO.getSkuNo());
                    uavCartDTOS.add(uavCartDTO);
                }
            }
        }
        return uavCartDTOS;
    }

    @Override
    public ResultBody<RecommendVO> recommend() {
        // 获取所有属于推荐的商品
        List<MallGoodsDO> mallGoodsList = mallGoodsDao.recommendMallGoods();
        if (mallGoodsList.size() == 0) {
            return ResultBody.success();
        }
        List<RecommendVO> recommendList = new ArrayList<>();
        // 获取所有一级分类
        List<Integer> categoryPrimaryIdList = mallGoodsList.stream().map(MallGoodsDO::getCategoryPrimaryId).distinct().collect(Collectors.toList());
        // 根据一级分类的id进行分组
        Map<Integer, List<MallGoodsDO>> goodMap = mallGoodsList.stream().collect(Collectors.groupingBy(MallGoodsDO::getCategoryPrimaryId));
        // 根据一级分类集合查询分类信息
        List<CategoryPrimaryDO> categoryPrimaryList = categoryDao.selectPrimaryListByIds(categoryPrimaryIdList);
        List<CategoryPrimaryDTO> primaryList = categoryPrimaryList.stream()
                .map(CategoryPrimaryDO::buildCategoryPrimaryDTO).collect(Collectors.toList());
        primaryList.forEach(categoryPrimaryDTO -> {
            List<MallGoodsDO> goodsDOList = goodMap.get(categoryPrimaryDTO.getId());
            RecommendVO recommendVO = new RecommendVO();
            recommendVO.setCategoryPrimaryDTO(categoryPrimaryDTO);
            recommendVO.setMallGoodsList(goodsDOList.stream().map(MallGoodsDO::buildListMallGoodsVO).collect(Collectors.toList()));
            recommendList.add(recommendVO);
        });
        return ResultBody.success(recommendList);
    }
}
