package com.mmc.pms.service.inspection;

import com.mmc.pms.auth.dto.LoginSuccessDTO;
import com.mmc.pms.common.ResultBody;
import com.mmc.pms.model.inspection.dto.AppCompanyInspectionDTO;
import com.mmc.pms.model.inspection.dto.CompanyInspectionDTO;
import com.mmc.pms.model.inspection.dto.IndustryTypeDTO;
import com.mmc.pms.model.inspection.vo.CompanyInspectionVO;
import com.mmc.pms.model.qo.CompanyInspectionQO;

import java.util.List;

/**
 * @author: zj
 * @Date: 2023/8/7 14:31
 */
public interface CompanyInspectionService {
    ResultBody insert(CompanyInspectionVO companyInspectionVO);

    ResultBody update(CompanyInspectionVO companyInspectionVO);

    ResultBody remove(Integer id);

    ResultBody<CompanyInspectionDTO> getCompanyInspectionById(Integer id);

    ResultBody<CompanyInspectionDTO> listCompanyInspectionPage(CompanyInspectionQO companyInspectionQO, LoginSuccessDTO loginSuccessDTO);

    ResultBody updateRemark(Integer id, String remark);

    ResultBody listInspectionPriceUnit();

    ResultBody<IndustryTypeDTO> listAPPCompanyInspectionPage(CompanyInspectionQO companyInspectionQO);

    void removeCompanyInspectionByCompanyInfoId(Integer companyInfoId);

    ResultBody<AppCompanyInspectionDTO> listAPPCompanyInspectionPageByCompanyId(List<Integer> companyInfoIds);
}
