package com.mmc.pms.model.inspection.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author: zj
 * @Date: 2023/8/7 14:19
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class CompanyInspectionVO implements Serializable {
    private static final long serialVersionUID = 6831143000193727239L;
    @ApiModelProperty(value = "id")
    private Integer id;
    @ApiModelProperty(value = "单位id")
    private Integer companyInfoId;
    @ApiModelProperty(value = "服务范围")
    private String serviceArea;
    @ApiModelProperty(value = "服务id")
    private Integer inspectionId;
    @ApiModelProperty(value = "服务标签")
    private Integer inspectionTagId;
    @ApiModelProperty(value = "报价")
    private BigDecimal price;
    @ApiModelProperty(value = "报价说明")
    private String priceRemark;
    @ApiModelProperty(value = "价格单位")
    private Integer inspectionPriceUnitId;
    @ApiModelProperty(value = "详情页")
    private String detailPage;
    @ApiModelProperty(value = "销售状态，0停售，1在售")
    private Integer saleState;
    @ApiModelProperty(value = "备注")
    private String remark;
    @ApiModelProperty(value = "图片/视频")
    private List<CompanyInspectionFileVO> companyInspectionFiles;
}
