package com.mmc.pms.entity.mall;

import com.mmc.pms.model.mall.GoodsSpecValuesVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * (GoodsSpecValuesDO)实体类
 *
 * @author makejava
 * @since 2023-07-24 21:18:28
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class GoodsSpecValuesDO implements Serializable {
    private static final long serialVersionUID = -35192084826222973L;

    private Integer id;
    /**
     * 规格id
     */
    private Integer goodsSpecId;
    /**
     * 选项名称
     */
    private String specValueName;
    /**
     * 料号
     */
    private String partNo;
    /**
     * 规格图片
     */
    private String specValueImage;
    /**
     * 销售价是否显示 0：否 1:是
     */
    private Integer showPrice;
    /**
     * 库存
     */
    private Integer stock;
    /**
     * 销售价格
     */
    private BigDecimal salePrice;
    /**
     * 渠道价格
     */
    private BigDecimal channelPrice;

    private Date createTime;

    private Date updateTime;

    public GoodsSpecValuesDO(GoodsSpecValuesVO d) {
        this.id = d.getId();
        this.goodsSpecId = d.getGoodsSpecId();
        this.specValueName = d.getSpecValueName();
        this.partNo = d.getPartNo();
        this.specValueImage = d.getSpecValueImage();
        this.showPrice = d.getShowPrice();
        this.channelPrice = d.getChannelPrice();
        this.salePrice = d.getSalePrice();
        this.stock = d.getStock();
    }

    public GoodsSpecValuesVO buildGoodsSpecValuesVO() {
        return GoodsSpecValuesVO.builder().id(id).goodsSpecId(goodsSpecId)
                .specValueName(specValueName).specValueImage(specValueImage)
                .partNo(partNo).showPrice(showPrice).stock(stock)
                .salePrice(salePrice).channelPrice(channelPrice).build();
    }
}

