package com.mmc.pms.entity;

import com.mmc.pms.model.sale.dto.ProductSpecPriceDTO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 产品规格价格配置表(ProductSpecPriceDO)实体类
 *
 * @author makejava
 * @since 2023-05-25 17:51:18
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ProductSpecPriceDO implements Serializable {
    private static final long serialVersionUID = 270307563560175486L;

    private Integer id;
    /**
     * 产品规格id
     */
    private Integer productSpecId;
    /**
     * 渠道等级id
     */
    private Integer cooperationTag;
    /**
     * 价格
     */
    private BigDecimal price;

    private Integer type;

    private Date createTime;

    private Date updateTime;

    private Integer leaseTerm;

    public ProductSpecPriceDTO buildProductSpecPriceDTO() {
        return ProductSpecPriceDTO.builder().id(this.id)
                .cooperationTag(this.cooperationTag)
                .price(this.price).createTime(this.createTime)
                .leaseTerm(this.leaseTerm).build();
    }
}

