package com.mmc.pms.model.mall;

import com.mmc.pms.model.group.Create;
import com.mmc.pms.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * @Author LW
 * @date 2023/7/24 17:44
 * 概要：
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class MallGoodsVO {
    @ApiModelProperty(value = "id", example = "1")
    @NotNull(message = "id不能为空", groups = {Update.class})
    private Integer id;

    @ApiModelProperty(value = "商品名称", example = "这是商品名称", required = true)
    @NotBlank(message = "商品名称不能为空", groups = {Update.class, Create.class})
    private String tradeName;

    @ApiModelProperty(value = "商品描述", example = "商品描述", required = true)
    @NotBlank(message = "商品描述不能为空", groups = {Update.class, Create.class})
    private String description;

    @ApiModelProperty(value = "商品资源:图片or视频及其他")
    @NotEmpty(message = "图片不能为空")
    private List<GoodsResourcesVO> resourcesList;

    @ApiModelProperty(value = "一级分类id", example = "1", required = true)
    @NotNull(message = "一级分类id不能为空", groups = {Update.class, Create.class})
    private Integer categoryPrimaryId;

    @ApiModelProperty(value = "二级分类id", example = "2", required = true)
    @NotNull(message = "二级分类id不能为空", groups = {Update.class, Create.class})
    private Integer categorySubId;

    @ApiModelProperty(value = "商品状态", example = "1", required = true)
    @NotNull(message = "商品状态不能为空", groups = {Update.class, Create.class})
    private Integer shelfStatus;

    @ApiModelProperty(value = "商品标签")
    private String goodsLabel;

    @ApiModelProperty(value = "标签是否显示 0否 1是")
    private Integer labelShow;

    @ApiModelProperty(value = "规格")
    @NotEmpty(message = "规格不能为空", groups = {Update.class, Create.class})
    private List<GoodsSpecVO> goodsSpecList;

    @ApiModelProperty(value = "商品详情 富文本")
    private String goodsDetails;

    @ApiModelProperty(value = "创建时间 用作列表回显")
    private Date createTime;

    @ApiModelProperty(value = "店铺id 小程序用")
    private Integer userAccountId;
}
