package com.mmc.pms.feign;

import com.mmc.pms.feign.hystrix.ImsApiHystrix;
import com.mmc.pms.model.categories.vo.CurriculumInfoVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @Author LW
 *
 * @date 2023/6/15 10:46 概要：
 */
@FeignClient(url = "${iuav.ims.url}", name = "ims", fallback = ImsApiHystrix.class)
public interface ImsAppApi {
  @GetMapping("/release/curriculum/feignCurriculumInfoList")
  List<CurriculumInfoVO> feignCurriculumInfoList(@RequestParam Integer categoriesId);

  @GetMapping("/release/curriculum/feignCountCurriculumInfo")
  int feignCountCurriculumInfo(@RequestParam Integer categoriesId);
}
