package com.mmc.pms.service.data.impl;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.dao.inspection.CompanyInspectionDao;
import com.mmc.pms.dao.lease.LeaseGoodsDao;
import com.mmc.pms.dao.mall.MallGoodsDao;
import com.mmc.pms.feign.ImsAppApi;
import com.mmc.pms.feign.UserAppApi;
import com.mmc.pms.model.data.dto.ProductReportDTO;
import com.mmc.pms.service.data.ProductReportService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @Author LW
 * @date 2023/9/16 17:51
 * 概要：
 */
@Service
public class ProductReportServiceImpl implements ProductReportService {
    @Resource
    UserAppApi userAppApi;
    @Resource
    MallGoodsDao mallGoodsDao;
    @Resource
    LeaseGoodsDao leaseGoodsDao;
    @Resource
    CompanyInspectionDao companyInspectionDao;
    @Resource
    ImsAppApi imsAppApi;

    @Override
    public ResultBody<ProductReportDTO> getProductReportData() {
        // 获取入驻商家总数
        ProductReportDTO joinStoreNumber = userAppApi.getJoinStoreNumber();
        // 获取销售商品个数
        int saleProduct = mallGoodsDao.getMallGoodsCount();
        // 获取出租商品个数
        int leaseProduct = leaseGoodsDao.getLeaseProduct();
        // 获取服务商品个数
        int serviceProduct = companyInspectionDao.getServiceProduct();
        // 获取在线课程个数
        int onlineCourse = imsAppApi.getCurriculumCount();
        if (joinStoreNumber == null) {
            ProductReportDTO productReportDTO = new ProductReportDTO();
            productReportDTO.setJoinStoreCount(0);
            productReportDTO.setBrandStore(0);
            productReportDTO.setRepairStore(0);
            productReportDTO.setTrainingInstitution(0);
            productReportDTO.setLeaseStore(0);
            productReportDTO.setServiceStore(0);
            productReportDTO.setSaleProduct(saleProduct);
            productReportDTO.setLeaseProduct(leaseProduct);
            productReportDTO.setServiceProduct(serviceProduct);
            productReportDTO.setOnlineCourse(onlineCourse);
            return ResultBody.success(productReportDTO);
        }
        joinStoreNumber.setSaleProduct(saleProduct);
        joinStoreNumber.setLeaseProduct(leaseProduct);
        joinStoreNumber.setServiceProduct(serviceProduct);
        joinStoreNumber.setOnlineCourse(onlineCourse);
        return ResultBody.success(joinStoreNumber);
    }
}
