package com.mmc.pms.entity.inspection;

import com.mmc.pms.model.inspection.dto.InspectionTagDTO;
import com.mmc.pms.model.inspection.vo.InspectionTagVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author: zj
 * @Date: 2023/8/3 16:43
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class InspectionTagDO implements Serializable {
    private static final long serialVersionUID = 7161953693996458346L;
    private Integer id;
    /**
     * 标签名称
     */
    private String tagName;
    /**
     * 服务id
     */
    private Integer inspectionId;

    public InspectionTagDO(InspectionTagVO inspectionTagVO) {
        this.id = inspectionTagVO.getId();
        this.tagName = inspectionTagVO.getTagName();
        this.inspectionId = inspectionTagVO.getInspectionId();
    }

    public InspectionTagDTO buildInspectionTagDTO() {
        return InspectionTagDTO.builder().id(this.id).tagName(this.tagName).inspectionId(this.inspectionId).build();
    }
}
