package com.mmc.pms.service.inspection.impl;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.common.ResultEnum;
import com.mmc.pms.dao.inspection.InspectionDao;
import com.mmc.pms.entity.inspection.InspectionDO;
import com.mmc.pms.model.inspection.dto.InspectionDTO;
import com.mmc.pms.model.inspection.vo.InspectionVO;
import com.mmc.pms.service.inspection.InspectionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author: zj
 * @Date: 2023/8/4 16:31
 */
@Service
public class InspectionServiceImpl implements InspectionService {
    @Autowired
    private InspectionDao inspectionDao;

    @Override
    public ResultBody insert(InspectionVO inspectionVO) {
        InspectionDO inspectionDO = new InspectionDO(inspectionVO);
        int count = inspectionDao.countSameName(inspectionVO.getId(), inspectionVO.getInspectionName());
        if (count > 0) {
            return ResultBody.error(ResultEnum.INSPECTION_NAME_CREATE_ERROR);
        }
        inspectionDao.insert(inspectionDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody update(InspectionVO inspectionVO) {
        InspectionDO inspectionDO = new InspectionDO(inspectionVO);
        int count = inspectionDao.countSameName(inspectionVO.getId(), inspectionVO.getInspectionName());
        if (count > 0) {
            return ResultBody.error(ResultEnum.INSPECTION_NAME_CREATE_ERROR);
        }
        inspectionDao.update(inspectionDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody remove(Integer id) {
        inspectionDao.remove(id);
        return ResultBody.success();
    }

    @Override
    public ResultBody<InspectionDTO> detail(Integer id) {
        InspectionDO inspectionDO = inspectionDao.getInspectionById(id);
        if (inspectionDO == null) {
            return ResultBody.success();
        }
        return ResultBody.success(inspectionDO.buildInspectionDTO());
    }
}
