package com.mmc.pms.entity.mall;

import com.mmc.pms.model.mall.PriceStockVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 价格库存表(PriceStockDO)实体类
 *
 * @author makejava
 * @since 2023-08-08 14:31:09
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class PriceStockDO implements Serializable {
    private static final long serialVersionUID = -64740182455155279L;

    private Integer id;
    /**
     * 商品id
     */
    private Integer mallGoodsId;
    /**
     * 商品规格
     */
    private String productSpec;
    /**
     * 销售价格
     */
    private BigDecimal salePrice;
    /**
     * sku图片
     */
    private String skuImage;
    /**
     * 渠道价格
     */
    private BigDecimal channelPrice;
    /**
     * 库存
     */
    private Integer stock;
    /**
     * sku编码
     */
    private String skuNo;

    private Date createTime;

    private Date updateTime;

    public PriceStockDO(PriceStockVO param, Integer id) {
        this.mallGoodsId = id;
        this.productSpec = param.getProductSpec();
        this.salePrice = param.getSalePrice();
        this.skuImage = param.getSkuImage();
        this.channelPrice = param.getChannelPrice();
        this.stock = param.getStock();
        this.skuNo = param.getSkuNo();
    }

    public PriceStockVO buildPriceStockVO() {
        return PriceStockVO.builder().id(id).productSpec(productSpec).salePrice(salePrice)
                .skuImage(skuImage).channelPrice(channelPrice).stock(stock).skuNo(skuNo).build();
    }
}

