package com.mmc.pms.entity.inspection;

import com.mmc.pms.model.inspection.dto.CompanyInspectionDTO;
import com.mmc.pms.model.inspection.vo.CompanyInspectionVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: zj
 * @Date: 2023/8/3 16:51
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class CompanyInspectionDO implements Serializable {
    private static final long serialVersionUID = 7878853810484957829L;
    private Integer id;
    /**
     * 单位id
     */
    private Integer companyInfoId;
    /**
     * 服务范围
     */
    private String serviceArea;
    /**
     * 服务id
     */
    private Integer inspectionId;
    /**
     * 服务标签
     */
    private Integer inspectionTagId;
    /**
     * 报价
     */
    private BigDecimal price;
    /**
     * 报价说明
     */
    private String priceRemark;
    /**
     * 价格单位
     */
    private Integer inspectionPriceUnitId;
    /**
     * 详情页
     */
    private String detailPage;
    /**
     * 销售状态，0停售，1在售
     */
    private Integer saleState;
    /**
     * 备注
     */
    private String remark;
    private Date createTime;

    IndustryTypeDO industryTypeDO;
    InspectionDO inspectionDO;
    InspectionTagDO inspectionTagDO;
    List<CompanyInspectionFileDO> inspectionFileDOS;

    public CompanyInspectionDTO buildCompanyInspectionDTO(){
        return CompanyInspectionDTO.builder().id(this.id).companyInfoId(this.companyInfoId).serviceArea(this.serviceArea)
                .inspectionId(this.inspectionId).inspectionTagId(this.inspectionTagId).price(this.price).priceRemark(this.priceRemark)
                .inspectionPriceUnitId(this.inspectionPriceUnitId).detailPage(this.detailPage).saleState(this.getSaleState())
                .remark(this.remark)
                .industryTypeDTO(this.industryTypeDO == null ? null : this.industryTypeDO.buildIndustryTypeDTO())
                .inspectionDTO(this.inspectionDO == null ? null : this.inspectionDO.buildInspectionDTO())
                .inspectionTagDTO(this.inspectionTagDO == null ? null : this.inspectionTagDO.buildInspectionTagDTO())
                .inspectionFirstImg(CollectionUtils.isEmpty(this.inspectionFileDOS) ? null :
                        this.inspectionFileDOS.stream().filter(i -> i.getFileType().equals(0) && i.getFirst().equals(1))
                                .findFirst().get().getFileUrl())
                .inspectionFileDTOS(CollectionUtils.isEmpty(this.inspectionFileDOS) ? null :
                        this.inspectionFileDOS.stream().map(CompanyInspectionFileDO :: buildCompanyInspectionFileDTO)
                                .collect(Collectors.toList()))
                .build();
    }

    public CompanyInspectionDO(CompanyInspectionVO companyInspectionVO) {
        this.id = companyInspectionVO.getId();
        this.companyInfoId = companyInspectionVO.getCompanyInfoId();
        this.serviceArea = companyInspectionVO.getServiceArea();
        this.inspectionId = companyInspectionVO.getInspectionId();
        this.inspectionTagId = companyInspectionVO.getInspectionTagId();
        this.price = companyInspectionVO.getPrice();
        this.priceRemark = companyInspectionVO.getPriceRemark();
        this.inspectionPriceUnitId = companyInspectionVO.getInspectionPriceUnitId();
        this.detailPage = companyInspectionVO.getDetailPage();
        this.saleState = companyInspectionVO.getSaleState();
        this.remark = companyInspectionVO.getRemark();
    }
}
