package com.mmc.pms.controller.lease;

/**
 * @Author LW
 * @date 2023/8/4 10:35
 * 概要：
 */

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.controller.BaseController;
import com.mmc.pms.model.group.Create;
import com.mmc.pms.model.group.Update;
import com.mmc.pms.model.lease.qo.LeaseGoodsQO;
import com.mmc.pms.model.lease.vo.LeaseGoodsVO;
import com.mmc.pms.model.sale.vo.BatchShelfVO;
import com.mmc.pms.service.lease.LeaseGoodsService;
import io.swagger.annotations.*;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @Author LW
 * @date 2023/7/24 16:56 概要：
 */
@RestController
@RequestMapping("/lease/goods")
@Api(tags = {"V1.0.3-租赁商品-相关接口"})
public class LeaseGoodsController extends BaseController {
    @Resource
    LeaseGoodsService leaseGoodsService;

    @ApiOperation(value = "新增租赁商品")
    @PostMapping("addLeaseGoods")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody addLeaseGoods(@Validated(value = {Create.class}) @RequestBody LeaseGoodsVO leaseGoodsVO, HttpServletRequest request) {
        return leaseGoodsService.addLeaseGoods(leaseGoodsVO, this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }

    @ApiOperation(value = "获取租期信息")
    @PostMapping("getLeaseTermInfo")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody getLeaseTermInfo() {
        return leaseGoodsService.getLeaseTermInfo();
    }

    @ApiOperation(value = "租赁商品详情")
    @PostMapping("leaseGoodsDetails")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = LeaseGoodsVO.class)})
    public ResultBody<LeaseGoodsVO> leaseGoodsDetails(@RequestParam Integer id) {
        return leaseGoodsService.leaseGoodsDetails(id);
    }

    @ApiOperation(value = "编辑租赁商品")
    @PostMapping("editLeaseGoods")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody editLeaseGoods(@Validated(value = {Update.class}) @RequestBody LeaseGoodsVO leaseGoodsVO, HttpServletRequest request) {
        return leaseGoodsService.editLeaseGoods(leaseGoodsVO, this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }

    @ApiOperation(value = "租赁商品列表")
    @PostMapping("leaseGoodsList")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = LeaseGoodsVO.class)})
    public ResultBody leaseGoodsList(@RequestBody LeaseGoodsQO param, HttpServletRequest request) {
        return leaseGoodsService.leaseGoodsList(param, this.getUserLoginInfoFromRedis(request));
    }

    @ApiOperation(value = "租赁商品批量上下架")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("batchOnShelfOrTakeDown")
    public ResultBody batchOnShelfOrTakeDown(@ApiParam(value = "商品上下架参数", required = true)
                                             @RequestBody BatchShelfVO batchOnShelfVO) {
        return leaseGoodsService.batchOnShelfOrTakeDown(batchOnShelfVO.getGoodsIds(), batchOnShelfVO.getStatus());
    }

    @ApiOperation(value = "租赁商品批量删除")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("batchRemoveWareInfo")
    public ResultBody batchRemoveWareInfo(
            @ApiParam(value = "商品id数组", required = true) @RequestBody List<Integer> list) {
        return leaseGoodsService.batchRemoveWareInfo(list);
    }
}
