package com.mmc.pms.controller.inspection;

import com.mmc.pms.common.Page;
import com.mmc.pms.common.ResultBody;
import com.mmc.pms.controller.BaseController;
import com.mmc.pms.model.inspection.dto.CompanyInspectionDTO;
import com.mmc.pms.model.inspection.dto.IndustryTypeDTO;
import com.mmc.pms.model.inspection.dto.InspectionDTO;
import com.mmc.pms.model.inspection.vo.CompanyInspectionVO;
import com.mmc.pms.model.inspection.vo.IndustryTypeVO;
import com.mmc.pms.model.qo.CompanyInspectionQO;
import com.mmc.pms.service.inspection.CompanyInspectionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @author: zj
 * @Date: 2023/8/4 16:26
 */
@Api(tags = {"团队服务"})
@RestController
@RequestMapping("/company-inspection/")
public class CompanyInspectionController extends BaseController {
    @Autowired
    private CompanyInspectionService companyInspectionService;

    @ApiOperation(value = "新增单位服务")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("insert")
    public ResultBody insert(@RequestBody CompanyInspectionVO companyInspectionVO){
        return companyInspectionService.insert(companyInspectionVO);
    }

    @ApiOperation(value = "修改单位服务")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("update")
    public ResultBody update(@RequestBody CompanyInspectionVO companyInspectionVO){
        return companyInspectionService.update(companyInspectionVO);
    }

    @ApiOperation(value = "删除单位服务")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("remove")
    public ResultBody remove(@RequestParam Integer id){
        return companyInspectionService.remove(id);
    }

    @ApiOperation(value = "单位服务详情")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CompanyInspectionDTO.class)})
    @GetMapping("getCompanyInspectionById")
    public ResultBody<CompanyInspectionDTO> getCompanyInspectionById(@RequestParam Integer id, HttpServletRequest request){
        return companyInspectionService.getCompanyInspectionById(id, this.getUserLoginInfoFromRedis(request));
    }

    @ApiOperation(value = "pc-单位服务列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CompanyInspectionDTO.class)})
    @PostMapping("listCompanyInspectionPage")
    public ResultBody<CompanyInspectionDTO> listCompanyInspectionPage(@Validated(value = {Page.class})
                                                                          @RequestBody CompanyInspectionQO companyInspectionQO,
                                                                      HttpServletRequest request){
        return companyInspectionService.listCompanyInspectionPage(companyInspectionQO, this.getUserLoginInfoFromRedis(request));
    }

    @ApiOperation(value = "修改备注")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("updateRemark")
    public ResultBody updateRemark(@RequestParam Integer id, @RequestParam(required = false) String remark){
        return companyInspectionService.updateRemark(id, remark);
    }

    @ApiOperation(value = "价格单位列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("listInspectionPriceUnit")
    public ResultBody listInspectionPriceUnit(){
        return companyInspectionService.listInspectionPriceUnit();
    }

    @ApiOperation(value = "单位服务列表-小程序展示")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CompanyInspectionDTO.class)})
    @PostMapping("listAPPCompanyInspectionPage")
    public ResultBody<IndustryTypeDTO> listAPPCompanyInspectionPage(@Validated(value = {Page.class})
                                                                      @RequestBody CompanyInspectionQO companyInspectionQO, HttpServletRequest request){
        return companyInspectionService.listAPPCompanyInspectionPage(companyInspectionQO, this.getUserLoginInfoFromRedis(request));
    }
}
