package com.mmc.pms.controller;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.model.category.qo.ModeInfoQO;
import com.mmc.pms.model.category.vo.ModeInfoVO;
import com.mmc.pms.model.sale.dto.BrandInfoDTO;
import com.mmc.pms.service.BrandManageService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @Author LW
 * @date 2023/3/14 13:22
 * 概要：
 */
@RestController
@RequestMapping("/brand")
@Api(tags = {"V1.0.3-品牌管理-相关接口"})
public class BrandManageController {

    @Autowired
    private BrandManageService brandManageService;

    @ApiOperation(value = "新增品牌")
    @GetMapping("addBrandInfo")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody addBrandInfo(@ApiParam(value = "品牌名称") @RequestParam String brandName) {
        return brandManageService.addBrandInfo(brandName);
    }

    @ApiOperation(value = "品牌列表")
    @GetMapping("listBrandInfo")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = BrandInfoDTO.class)})
    public ResultBody<BrandInfoDTO> listBrandInfo(@RequestParam Integer pageNo, @RequestParam Integer pageSize) {
        return ResultBody.success(brandManageService.listBrandInfo(pageNo, pageSize));
    }

    @ApiOperation(value = "删除品牌---待与运营沟通")
    @GetMapping("deleteBrandInfo")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody deleteBrandInfo(Integer id) {
        return brandManageService.deleteBrandInfo(id);
    }

    @ApiOperation(value = "编辑品牌")
    @GetMapping("editBrandInfo")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody editBrandInfo(Integer id, String brandName) {
        return brandManageService.editBrandInfo(id, brandName);
    }

    @ApiOperation(value = "新增型号")
    @PostMapping("addMode")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody addMode(@RequestBody ModeInfoVO param) {
        return brandManageService.addMode(param);
    }

    @ApiOperation(value = "型号列表")
    @PostMapping("modeList")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ModeInfoVO.class)})
    public ResultBody modeList(@RequestBody ModeInfoQO param) {
        return ResultBody.success(brandManageService.modeList(param));
    }

    @ApiOperation(value = "编辑型号")
    @PostMapping("editMode")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody editMode(@RequestBody ModeInfoVO param) {
        return brandManageService.editMode(param);
    }


}
