package com.mmc.pms.auth.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;

/**
 * @Author small
 * @Date 2023/7/4 10:04
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class CompanyInfoVO {
    private static final long serialVersionUID = 3247519744829926132L;
    @ApiModelProperty(value = "id")

    private Integer id;
    @ApiModelProperty(value = "单位类型，0科比特，1加盟公司", example = "0")
    private Integer companyType;
    @ApiModelProperty(value = "单位名称", example = "科比特")

    private String companyName;
    @ApiModelProperty(value = "单位全称", example = "浙江科比特创新科技有限公司")

    private String fullName;
    @ApiModelProperty(value = "省份名称", example = "广东省")

    private String province;
    @ApiModelProperty(value = "城市名称", example = "深圳市")

    private String city;
    @ApiModelProperty(value = "县区名称", example = "南山区")

    private String district;
    @ApiModelProperty(value = "详细地址", example = "西丽街道万科云城国际创新谷6栋")

    private String address;
    @ApiModelProperty(value = "联系人", example = "lx")
    private String companyUserName;
    @ApiModelProperty(value = "联系电话", example = "13925255742")
    private String phoneNum;
    @ApiModelProperty(value = "备注")
    private String remark;
}
