package com.mmc.pms.model.order.dto;

import com.mmc.pms.entity.RepoCashDO;
import com.mmc.pms.model.other.dto.KdnExpDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author small @Date 2023/5/25 9:45 @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
// @ApiModel(value = "com.mmc.csf.model.dto.OrderInfoDTO", description = "云仓订单DTO")
public class OrderInfoDTO implements Serializable {
    private static final long serialVersionUID = 1572467108563651846L;

    @ApiModelProperty(value = "ID")
    private Integer id;

    @ApiModelProperty(value = "订单编号")
    private String orderNo;

    @ApiModelProperty(value = "商品ID")
    private Integer wareInfoId;

    @ApiModelProperty(value = "商品编号")
    private String wareNo;

    @ApiModelProperty(value = "商品标题")
    private String wareTitle;

    @ApiModelProperty(value = "商品图片")
    private String wareImg;

    @ApiModelProperty(value = "套餐（sku）ID")
    private Integer skuInfoId;

    @ApiModelProperty(value = "套餐（sku）名称")
    private String skuTitle;

    @ApiModelProperty(value = "购买用户ID")
    private Integer repoAccountId;

    @ApiModelProperty(value = "用户UID")
    private String uid;

    @ApiModelProperty(value = "买家name")
    private String buyerName;

    @ApiModelProperty(value = "买家电话")
    private String buyerPhone;

    @ApiModelProperty(value = "单价")
    private BigDecimal unitPrice;

    @ApiModelProperty(value = "购买的商品数量")
    private Integer wareNum;

    @ApiModelProperty(value = "应付款金额")
    private BigDecimal shouldPay;

    @ApiModelProperty(value = "实收款金额")
    private BigDecimal actualPay;

    @ApiModelProperty(value = "订单类型：0租赁 100购买")
    private Integer orderType;

    @ApiModelProperty(value = "押金")
    private BigDecimal deposit;

    @ApiModelProperty(value = "租金总金额")
    private BigDecimal rentPrice;

    @ApiModelProperty(value = "租约开始日")
    private Date startDate;

    @ApiModelProperty(value = "租约结束日")
    private Date endDate;

    @ApiModelProperty(value = "付款天数")
    private Integer payDay;

    @ApiModelProperty(value = "交易状态：查订单状态字典")
    private String tranStatus;

    @ApiModelProperty(value = "减库方式 0:买家拍下减库存 1:卖家付款减库存")
    private Integer exWare;

    @ApiModelProperty(value = "用户备注")
    private String remark;

    @ApiModelProperty(value = "平台人员备注")
    private String pfRemark;

    @ApiModelProperty(value = "关闭原因")
    private String shutReason;

    @ApiModelProperty(value = "交易编号")
    private String payNo;

    @ApiModelProperty(value = "支付时间")
    private Date payTime;

    @ApiModelProperty(value = "发货时间")
    private Date sendWareTime;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "物流信息/收货地址信息")
    private OrderReceiptDTO receipt;

    @ApiModelProperty(value = "退款单详情信息,无则为null")
    private OrderRefundDTO orderRefund;

    @ApiModelProperty(value = "发货-物流动态,无则为null")
    private KdnExpDTO express;

    @ApiModelProperty(value = "退货-物流动态,无则为null")
    private KdnExpDTO refundExpress;

    @ApiModelProperty(value = "质检详情,无则为null")
    private List<OrderVcuDTO> vcus;

    public RepoCashDO buildRepoCashDO() {
        return RepoCashDO.builder()
                .uid(this.uid)
                .accountName(this.buyerName)
                .orderInfoId(this.id)
                .orderNo(this.orderNo)
                .skuInfoId(this.skuInfoId)
                .skuTitle(this.skuTitle)
                .wareInfoId(this.wareInfoId)
                .wareTitle(this.wareTitle)
                .wareNo(this.wareNo)
                .build();
    }
}
