package com.mmc.payment.model.dto.user;

import com.mmc.payment.model.vo.user.CooperationTagVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author: zj
 * @Date: 2023/5/18 17:25
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class UserAccountSimpleDTO implements Serializable {
    private static final long serialVersionUID = -4408363798593041955L;
    @ApiModelProperty(value = "用户id")
    private Integer id;
    @ApiModelProperty(value = "用户类型")
    private Integer accountType;
    @ApiModelProperty(value = "用户uid")
    private String uid;
    @ApiModelProperty(value = "手机号")
    private String phoneNum;
    @ApiModelProperty(value = "用户名称")
    private String userName;
    @ApiModelProperty(value = "用户昵称")
    private String nickName;
    @ApiModelProperty(value = "用户头像")
    private String userImg;
    @ApiModelProperty(value = "openid")
    private String openid;
    @ApiModelProperty(value = "用户性别：0未知、1男、2女")
    private Integer userSex;
    @ApiModelProperty(value = "用户邮箱")
    private String email;
    @ApiModelProperty(value = "用户来源，0自然流、1海报、2抖音、3公众号、4社群、5招投标、6官网")
    private Integer source;
    @ApiModelProperty(value = "用户可用状态：0禁用、1可用")
    private Integer accountStatus;
    @ApiModelProperty(value = "账号类型：0后台管理账号 ; 100云享飞-客户端;")
    private Integer portType;
    @ApiModelProperty(value = "企业认证状态, 0未通过，1通过")
    private Integer companyAuthStatus;
    @ApiModelProperty(value = "用户合作标签")
    private List<CooperationTagVO> cooperationTagVOS;
}
