package com.mmc.payment.feign.hystrix;

import com.mmc.payment.feign.UserAppApi;
import com.mmc.payment.model.dto.user.UserAccountSimpleDTO;
import com.mmc.payment.model.qo.UserAccountQO;
import com.mmc.payment.model.vo.user.BUserAccountQO;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

/**
 * @author: zj
 * @Date: 2023/5/18 17:08
 */
@Slf4j
public class UserAppApiHystrix implements UserAppApi {
    @Override
    public UserAccountSimpleDTO feignGetUserSimpleInfo(Integer userAccountId, String token) {
        log.error("熔断：feignGetUserSimpleInfo：{}", userAccountId);
        return null;
    }

    @Override
    public List<Integer> feignListUserAccountIds(Integer provinceCode, Integer cityCode, Integer districtCode, String token) {
        log.error("熔断：feignListUserAccountIds：{}， {}， {}", provinceCode, cityCode, districtCode);
        return null;
    }

    @Override
    public List<UserAccountSimpleDTO> feignListBAccountPage(BUserAccountQO bUserAccountQO, String token) {
        log.error("熔断：feignListBAccountPage：{}", bUserAccountQO);
        return null;
    }

    @Override
    public List<UserAccountSimpleDTO> feignListAppUserAccount(UserAccountQO userAccountQO, String token) {
        log.error("熔断：feignListAppUserAccount：{}", userAccountQO);
        return null;
    }
}
