package com.mmc.payment.enums;

/**
 * @author 作者 geDuo
 * @version 创建时间：2021年10月14日 下午4:08:18
 * @explain 0下单初始化->100待分配运营->200需求确认->300订单确认->400待支付->500调度中->600作业中->700验收通过->900订单关闭
 */

/**
 * 0下单成功-> 100（待分配运营）已分配运营-> 200（待需求确认）已经需求确认-> 300(待确认订单)已确认订单->
 * 400（待预支付）已预支付-> 500(调度中)调度完成-> 600(作业中)作业完成-> 700(待验收结算)验收通过-> 900订单关闭
 *
 * @author geDuo
 */
public enum OrderPayStatus {
    WAIT("WAIT", "待支付"),

    SUCCESS("SUCCESS", "支付成功"),

    REFUND("REFUND", "转入退款"),

    NOTPAY("NOTPAY", "未支付"),

    CLOSED("CLOSED", "已关闭"),

    REVOKED("REVOKED", "已撤销（付款码支付）"),

    USERPAYING("USERPAYING", "用户支付中（付款码支付）"),

    PAYERROR("PAYERROR", "支付失败(其他原因，如银行返回失败)");


    private String status;
    private String doing;

    OrderPayStatus(String status, String doing) {
        this.status = status;
        this.doing = doing;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getDoing() {
        return doing;
    }

    public void setDoing(String doing) {
        this.doing = doing;
    }


}
