package com.mmc.payment.entity.repo;

import com.mmc.payment.model.dto.repo.RepoRcdTeamDTO;
import com.mmc.payment.model.dto.repo.RepoRebateWalletDTO;
import com.mmc.payment.model.dto.user.RepoAccountDTO;
import com.mmc.payment.model.vo.repo.RepoAccountVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;

/**
 * @Author small
 * @Date 2023/5/23 19:39
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class RepoAccountDO implements Serializable {
    private static final long serialVersionUID = 6313612168648022544L;
    private Integer id;
    private String uid;
    private String accountName;
    private Integer accountType;
    private String phoneNum;
    private Integer realAuthStatus;
    private Integer entAuthStatus;
    private Integer channelAuthStatus;
    private Integer channelClass;
    private String openId;
    private String unionId;
    private String nickName;
    private String resAddress;
    private String headerImg;
    private BigDecimal lon;
    private BigDecimal lat;
    private String ports;
    private String remark;
    private Integer deleted;
    private Date createTime;
    private Date updateTime;
    private Integer sale;
    private Integer source;
    private Integer rcdCompanyId;

    private RepoAccountDO rcdRepo;
    /**
     * 额外字段
     */
    private Integer white;
    private Date entAuthTime;
    private String entName;
    private Date rcdCreateTime;
    private String rcdRemark;

    public RepoAccountDTO buildRepoAccountDTO() {
        Integer white = 0;
        if (rcdRepo != null && rcdRepo.getSale() == 1) {
            white = 1;
        }
        return RepoAccountDTO.builder().id(this.id).uid(this.uid).accountName(this.accountName)
                .accountType(this.accountType).phoneNum(this.phoneNum).realAuthStatus(this.realAuthStatus)
                .entAuthStatus(this.entAuthStatus).channelAuthStatus(this.channelAuthStatus).nickName(this.nickName)
                .resAddress(this.resAddress).headerImg(this.headerImg).lon(this.lon).lat(this.lat).remark(this.remark)
                .deleted(this.deleted).createTime(this.createTime).updateTime(this.updateTime)
                .ports(StringUtils.isEmpty(this.ports) ? null
                        : new HashSet<String>(Arrays.asList(this.ports.split(","))))
                .entAuthTime(this.entAuthTime).unionId(this.unionId).entName(this.entName).openId(this.openId)
                .rcdUid(this.rcdRepo == null ? null : this.rcdRepo.getUid())
                .rcdAccountId(this.rcdRepo == null ? null : this.rcdRepo.getId())
                .rcdAccountName(this.rcdRepo == null ? null : this.rcdRepo.getAccountName())
                .rcdNickName(this.rcdRepo == null ? null : this.rcdRepo.getNickName())
                .channelClass(this.channelClass).sale(this.sale).white(white).source(this.source)
                .rcdCompanyId(this.rcdCompanyId)
                .build();
    }

    public RepoRcdTeamDTO builderRepoRcdTeamDTO() {
        return RepoRcdTeamDTO.builder().RepoAccountName(this.accountName).id(this.id).accountType(this.accountType)
                .realAuthStatus(this.realAuthStatus).entAuthStatus(this.entAuthStatus).createTime(this.rcdCreateTime)
                .phoneNum(this.phoneNum).nickName(this.nickName).remark(this.rcdRemark).uid(this.uid).entName(this.entName).build();
    }

    public RepoRebateWalletDTO buildRepoRebateWalletDTO() {
        return RepoRebateWalletDTO.builder().repoAccountId(this.id).uid(this.uid).nickName(this.getNickName()).build();
    }

    public void buildName() {
        if (StringUtils.isBlank(this.accountName) && StringUtils.isBlank(this.entName)) {
            this.accountName = null;
        } else if (StringUtils.isBlank(this.accountName) && !StringUtils.isBlank(this.entName)) {
            this.accountName = this.entName;
        } else if (!StringUtils.isBlank(this.accountName) && !StringUtils.isBlank(this.entName)) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.accountName);
            sb.append("(");
            sb.append(this.entName);
            sb.append(")");
            this.accountName = sb.toString();
        }
    }

    public RepoAccountDO(RepoAccountVO repoAccountVO) {
        this.id = repoAccountVO.getId();
        this.headerImg = repoAccountVO.getHeaderImg();
        this.nickName = repoAccountVO.getNickName();
        this.resAddress = repoAccountVO.getResAddress();
        this.lon = repoAccountVO.getLon();
        this.lat = repoAccountVO.getLat();
    }

}
