package com.mmc.payment.common.util;

import org.springframework.beans.BeanUtils;

import java.util.Objects;

/**
 * @Author small
 * @Date 2023/5/30 10:21
 * @Version 1.0
 */
public class BeanCopyUtils {

    public static <T> T properties(Object source, T target) {
        if (Objects.isNull(source)) {
            return target;
        }
        BeanUtils.copyProperties(source, target);
        return target;
    }

    public static <T> T properties(Object source, Class<T> target) {
        T t = null;
        try {
            t = target.newInstance();
            if (Objects.isNull(source)) {
                return t;
            }
        } catch (InstantiationException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        BeanUtils.copyProperties(source, t);
        return t;
    }
}
