package com.mmc.payment.service;

import com.mmc.payment.common.PageResult;
import com.mmc.payment.common.ResultBody;
import com.mmc.payment.model.dto.BaseAccountDTO;
import com.mmc.payment.model.dto.PayCashResultDTO;
import com.mmc.payment.model.dto.RepoCashDTO;
import com.mmc.payment.model.qo.RepoCashQO;
import com.mmc.payment.model.qo.UserCashQO;
import com.mmc.payment.model.vo.RepoCashVO;
import com.mmc.payment.model.vo.RepoOrderPayVO;
import com.mmc.payment.model.vo.WalletUsersVO;

import java.math.BigDecimal;

/**
 * @Author small
 * @Date 2023/5/29 17:59
 * @Version 1.0
 */
public interface RepoCashService {
    PageResult listPageRepoCash(BaseAccountDTO cuser, RepoCashQO param);

    void updateCashRemark(Integer id, String remark);

    /**
     * 充值
     *
     * @param cash
     * @return
     */
    ResultBody reqCash(BaseAccountDTO cuser, RepoCashVO cash);

    ResultBody amountOfRefund(BaseAccountDTO cuser, String orderNo, BigDecimal actualPay, Integer repoAccountId, String refundNo);

    ResultBody dedCash(BaseAccountDTO cuser, RepoCashVO cash);

    RepoCashDTO getRefundInfo(String refundNo);

    BigDecimal RemainingBalance(Integer uid);

    ResultBody orderPayment(BaseAccountDTO currentAccount, String orderNo);

    PayCashResultDTO payCashOrder(RepoOrderPayVO orderPay);

    PageResult listPagePayManager(BaseAccountDTO currentAccount, UserCashQO param);


    ResultBody walletUsers(WalletUsersVO walletUsersVO);

    ResultBody cashType();
}
