package com.mmc.payment.model.vo;

import com.mmc.payment.common.Update;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author small
 * @Date 2023/5/29 16:13
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.model.vo.FlyerWorkStatusVO", description = "新增/修改参数类")
public class FlyerWorkStatusVO implements Serializable {
    private static final long serialVersionUID = -1274280958579567505L;
    @ApiModelProperty(value = "id")
    @NotNull(message = "更新时ID不能为空", groups = { Update.class })
    private Integer id;
    @ApiModelProperty(value = "常驻地址", example = "深圳市")
    @NotEmpty(message = "常驻地址不能为空", groups = { Update.class })
    private String resAddress;
    @ApiModelProperty(value = "经度")
    @NotNull(message = "更新时经度不能为空", groups = { Update.class })
    private Double lon;
    @ApiModelProperty(value = "纬度")
    @NotNull(message = "更新时纬度不能为空", groups = { Update.class })
    private Double lat;
    @ApiModelProperty(value = "工作状态")
    @NotNull(message = "workStatus不能为空", groups = { Update.class })
    private Integer workStatus;
}

