package com.mmc.payment.model.qo;

import com.mmc.payment.common.Page;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Author small
 * @Date 2023/5/24 10:18
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.model.qo.UserAccountQO", description = "账号查询条件封装类")
public class UserAccountQO implements Serializable {
    private static final long serialVersionUID = -2780882438255193738L;

    @ApiModelProperty(value = "关键字", required = false)
    private String keyword;

    @ApiModelProperty(value = "地区", required = false)
    private String area;

    @ApiModelProperty(value = "角色id", required = false)
    private Integer roleId;

    @ApiModelProperty(value = "账号状态：0禁用 1可用")
    private Integer accountStatus;

    @ApiModelProperty(value = "账号状态：0合伙人 1员工")
    private Integer userType;

    @ApiModelProperty(value = "用户id集合")
    private List<Integer> userIds;

    @ApiModelProperty(value = "推荐单位id")
    private Integer rcdCompanyId;

    @ApiModelProperty(value="单位集合", hidden = true)
    private List<Integer> companys;

    @ApiModelProperty(value = "页码", required = true)
    @NotNull(message = "页码不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;

    @ApiModelProperty(value = "每页显示数", required = true)
    @NotNull(message = "每页显示数不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}
