package com.mmc.payment.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author small
 * @Date 2023/5/29 17:32
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.model.dto.TaskFlyerCostDTO", description = "飞手工资DTO")
public class TaskFlyerCostDTO implements Serializable {
    private static final long serialVersionUID = 4411028098471010440L;
    @ApiModelProperty(value = "飞手工资id")
    private Integer id;
    @ApiModelProperty(value = "订单id")
    private Integer orderTaskId;
    @ApiModelProperty(value = "飞手日薪")
    private BigDecimal flyerWag;
    @ApiModelProperty(value = "飞手每日补贴")
    private BigDecimal flyerSudy;
    @ApiModelProperty(value = "每月工资结算日")
    private Integer payDay;
    @ApiModelProperty(value = "租房补贴")
    private BigDecimal rentHouseSudy;
    @ApiModelProperty(value = "交通补贴")
    private BigDecimal trafficSudy;
    @ApiModelProperty(value = "支付比例(例如0.95)")
    private BigDecimal payPersent;
    @ApiModelProperty(value = "设备信息")
    private String deviceInfo;
    @ApiModelProperty(value = "生成时间")
    private Date createTime;
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "任务编号")
    private String orderNo;
    @ApiModelProperty(value = "任务名称")
    private String orderName;
    @ApiModelProperty(value = "飞手数量")
    private Integer flyerNum;
    @ApiModelProperty(value = "服务类型")
    private String inspectionName;
    @ApiModelProperty(value = "飞手类型（0个人飞手 1飞手机构）")
    private Integer flyerType;
   // @ApiModelProperty(value = "任务工资信息列表")
    //private List<WagTermDetailDTO> details;
    @ApiModelProperty(value = "任务开始日")
    private Date startTime;
    @ApiModelProperty(value = "任务结束日")
    private Date endTime;

    @ApiModelProperty(value = "高温补贴")
    private BigDecimal hotSudy;
    @ApiModelProperty(value = "预估金额")
    private BigDecimal estimateWag;
    @ApiModelProperty(value = "补助标签")
    private String sudyTag;

    public void defaultValue() {
        if (this.flyerWag == null) {
            this.flyerWag = BigDecimal.ZERO;
        }

        if (this.flyerSudy == null) {
            this.flyerSudy = BigDecimal.ZERO;
        }

        if (this.rentHouseSudy == null) {
            this.rentHouseSudy = BigDecimal.ZERO;
        }

        if (this.trafficSudy == null) {
            this.trafficSudy = BigDecimal.ZERO;
        }

        if (this.payPersent == null) {
            this.payPersent = BigDecimal.ZERO;
        }

        if(this.hotSudy == null) {
            this.hotSudy = BigDecimal.ZERO;
        }
    }
}
