package com.mmc.payment.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @Author small
 * @Date 2023/5/24 10:19
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.model.dto.RoleInfoDTO", description = "角色信息DTO")
public class RoleInfoDTO implements Serializable {
    private static final long serialVersionUID = -4791023169682602298L;
    @ApiModelProperty(value = "角色ID")
    private Integer id;
    @ApiModelProperty(value = "角色编号")
    private String roleNo;
    @ApiModelProperty(value = "角色名称")
    private String roleName;
    @ApiModelProperty(value = "是否为管理角色:0否 1是")
    private Integer admin;// 是否为管理角色
    @ApiModelProperty(value = "是否为运营角色:0否 1是")
    private Integer operate;
    @ApiModelProperty(value = "是否为系统角色:0否 1是")
    private Integer system;
    @ApiModelProperty(value = "是否为PMC发货角色:0否 1是")
    private Integer pmc;//PMC发货角色
    @ApiModelProperty(value = "是否可用:0否 1是")
    private Integer roleStatus;
    @ApiModelProperty(value = "备注")
    private String remark;

}
