package com.mmc.payment.model.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author small
 * @Date 2023/5/23 19:35
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.model.dto.RepoWalletDTO", description = "钱包DTO")
public class RepoWalletDTO implements Serializable {
    private static final long serialVersionUID = 5306992787421065922L;
    @ApiModelProperty(value = "ID")
    private Integer id;
    @ApiModelProperty(value = "账号id")
    private Integer repoAccountId;
    @ApiModelProperty(value = "现金余额")
    private BigDecimal cashAmt;
    @ApiModelProperty(value = "已付金额")
    private BigDecimal cashPaid;
    @ApiModelProperty(value = "冻结中-金额")
    private BigDecimal cashFreeze;
    //@ApiModelProperty(value = "奖励-余额")
    // private BigDecimal rcdRebateAmt;
    // @ApiModelProperty(value = "累计提现")
    // private BigDecimal rebateWdl;
    // @ApiModelProperty(value = "提现冻结金额")
    //private BigDecimal rebateFreeze;
    @ApiModelProperty(value = "平台备注")
    private String remark;
    @ApiModelProperty(value = "手机号")
    private String phoneNum;
    @ApiModelProperty(value = "用户名称")
    private String userName;
    @ApiModelProperty(value = "用户昵称")
    private String nickName;
    @ApiModelProperty(value = "账号类型：0后台管理账号 ; 100云享飞-客户端;")
    private Integer portType;
    @ApiModelProperty(value = "uid")
    private String uid;
/*
    public void defaultRebateValue() {
        if (this.rcdRebateAmt == null) {
            this.rcdRebateAmt = BigDecimal.ZERO;
        }

        if (this.rebateWdl == null) {
            this.rebateWdl = BigDecimal.ZERO;
        }
    }*/
}
