package com.mmc.payment.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author small
 * @Date 2023/5/23 20:01
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.model.dto.RepoRebateWalletDTO", description = "奖励管理DTO")
public class RepoRebateWalletDTO implements Serializable {
    private static final long serialVersionUID = 4874698532029550117L;
    @ApiModelProperty(value = "UID")
    private String uid;
    @ApiModelProperty(value = "用户ID")
    private Integer repoAccountId;
    @ApiModelProperty(value = "昵称")
    private String nickName;
    @ApiModelProperty(value = "可提现-奖励金余额")
    private BigDecimal rcdRebateAmt;
    @ApiModelProperty(value = "提现中(冻结中)金额")
    private BigDecimal rebateFreeze;
    @ApiModelProperty(value = "已提现金额")
    private BigDecimal rebateWdl;
    @ApiModelProperty(value = "累计总额")
    private BigDecimal totalRebate;
    @ApiModelProperty(value = "团队人数")
    private Integer teamUserNum;

    public void computerTotalRebate() {
        this.totalRebate = BigDecimal.ZERO;
        if (this.rcdRebateAmt != null && this.rcdRebateAmt.compareTo(BigDecimal.ZERO) > 0) {
            this.totalRebate = this.totalRebate.add(rcdRebateAmt);
        }

        if (this.rebateFreeze != null && this.rebateFreeze.compareTo(BigDecimal.ZERO) > 0) {
            this.totalRebate = this.totalRebate.add(rebateFreeze);
        }

        if (this.rebateWdl != null && this.rebateWdl.compareTo(BigDecimal.ZERO) > 0) {
            this.totalRebate = this.totalRebate.add(rebateWdl);
        }
        this.totalRebate = this.totalRebate.setScale(2, BigDecimal.ROUND_DOWN);
    }

    public void defaultValue() {
        this.rcdRebateAmt = this.rcdRebateAmt == null ? BigDecimal.ZERO : this.rcdRebateAmt;
        this.rebateFreeze = this.rebateFreeze == null ? BigDecimal.ZERO : this.rebateFreeze;
        this.rebateWdl = this.rebateWdl == null ? BigDecimal.ZERO : this.rebateWdl;
        this.totalRebate = this.totalRebate == null ? BigDecimal.ZERO : this.totalRebate;
    }

}
