package com.mmc.payment.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author small
 * @Date 2023/5/27 15:22
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.model.dto.PayCashResultDTO", description = "云仓支付扣款DTO")
public class PayCashResultDTO implements Serializable {
    private static final long serialVersionUID = 5187623898281150213L;
    @ApiModelProperty(value = "响应状态（200成功，其他失败）")
    private String status;
    @ApiModelProperty(value = "响应消息")
    private String message;
    @ApiModelProperty(value = "交易编号")
    private String payNo;
    @ApiModelProperty(value = "本次操作支付现金金额")
    private BigDecimal cashPaid;

    public static PayCashResultDTO error(String status, String message) {
        return PayCashResultDTO.builder().status(status).message(message).build();
    }

    public static PayCashResultDTO success(BigDecimal cashPaid, String payNo) {
        return PayCashResultDTO.builder().status("200").message("success").cashPaid(cashPaid).payNo(payNo).build();
    }
}

