package com.mmc.payment.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author small
 * @Date 2023/5/29 17:29
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.flyer.dto.FlyerRecordDTO", description = "飞手记录DTO")
public class FlyerRecordDTO implements Serializable {
    private static final long serialVersionUID = -188321537755558914L;
    private Integer flyerAccountId;
    @ApiModelProperty("订单数")
    private Integer orderNum;
    @ApiModelProperty("任务天数")
    private Integer workDay;
    @ApiModelProperty("综合评分")
    private BigDecimal score;
    @ApiModelProperty("差评数")
    private Integer negtNum;
    @ApiModelProperty("好评数")
    private Integer praiseNum;
    @ApiModelProperty("差评率")
    private BigDecimal negtRate;

    public void defaultValue() {
        if (orderNum == null) {
            orderNum = 0;
        }

        if (workDay == null) {
            workDay = 0;
        }

        if (score == null) {
            score = BigDecimal.ZERO;
        }

        if (negtNum == null) {
            negtNum = 0;
        }

        if (praiseNum == null) {
            praiseNum = 0;
        }
    }

    public void compareNegtRate() {
        this.negtRate = (BigDecimal.valueOf(negtNum).divide(BigDecimal.valueOf(negtNum + praiseNum))).setScale(2,
                BigDecimal.ROUND_HALF_DOWN);
    }
}
