package com.mmc.payment.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/5/29 16:16
 * @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
//@ApiModel(value = "com.mmc.csf.model.dto.FlyerRcdTeamDTO", description = "飞手推荐团队DTO")
public class FlyerRcdTeamDTO implements Serializable {
    @ApiModelProperty(value = "id")
    private Integer id;
    @ApiModelProperty(value = "账户名称")
    private String FlyerAccountName;
    @ApiModelProperty(value = "uid")
    private String uid;
    @ApiModelProperty(value = "手机号")
    private String phoneNum;
    @ApiModelProperty(value = "发展时间")
    private Date createTime;
    @ApiModelProperty(value = "昵称")
    private String nickName;
    @ApiModelProperty(value = "企业认证状态：0未认证1已认证")
    private Integer entAuthStatus;
    @ApiModelProperty(value = "实名认证：0未实名1已实名2未通过")
    private Integer realAuthStatus;
    @ApiModelProperty(value = "账户类型 0游客1普通用户2个人飞手3飞手机构")
    private Integer accountType;
    @ApiModelProperty(value = "备注")
    private String remark;
}
