package com.mmc.payment.model.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @Author small
 * @Date 2023/5/29 17:30
 * @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class FlyerOrderTaskDTO implements Serializable {
    private static final long serialVersionUID = 4288411060058354326L;
    private Integer id;
    private Integer orderId;
    private Integer flyerAccountId;
    private Integer orderType;
    private Integer virtualTeamId;
    private String orderName;
    private String orderNo;

    public FlyerOrderTaskDTO(OrderTaskDTO d) {
        this.orderId = d.getId();
        this.orderName = d.getOrderName();
        this.orderNo = d.getOrderNo();
    }
}

