package com.mmc.payment.model.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/5/29 16:17
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.model.dto.FlyerInfoDTO", description = "飞手信息DTO")
public class FlyerInfoDTO implements Serializable {
    private static final long serialVersionUID = -5443010919398186590L;
    @ApiModelProperty(value = "飞手信息表id")
    private Integer id;
    @ApiModelProperty(value = "飞手信息表uid")
    private String uid;
    @ApiModelProperty(value = "飞手id，个人飞手必填，机构飞手为空")
    private Integer flyerAccountId;
    @ApiModelProperty(value = "机构id")
    private Integer flyerEntId;
    @ApiModelProperty(value = "飞手类型，0个人飞手，1机构飞手 2机构")
    private Integer flyerType;
    @ApiModelProperty(value = "飞手姓名")
    private String flyerName;
    @ApiModelProperty(value = "飞行执照认证状态")
    private Integer licStatus;
    @ApiModelProperty(value = "飞手执照名称")
    private String licName;
    @ApiModelProperty(value = "飞手执照编号")
    private String licNumber;
    @ApiModelProperty(value = "飞行执照url")
    private String licImg;
    @ApiModelProperty(value = "联系电话")
    private String phoneNum;
    @ApiModelProperty(value = "身份证号")
    private String idNumber;
    @ApiModelProperty(value = "性别")
    private Integer sex;
    @ApiModelProperty(value = "民族")
    private String nation;
    @ApiModelProperty(value = "出生日期")
    private Date birthday;
    @ApiModelProperty(value = "地址")
    private String address;
    @ApiModelProperty(value = "签发机关")
    private String signOrg;
    @ApiModelProperty(value = "有效开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date startDate;
    @ApiModelProperty(value = "有效结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date endDate;
    @ApiModelProperty(value = "身份证正面照url")
    private String frontIdImg;
    @ApiModelProperty(value = "身份证背面照url")
    private String backIdImg;
    @ApiModelProperty(value = "实名认证备注")
    private String authRemark;
    @ApiModelProperty(value = "生成时间")
    private Date createTime;
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
    @ApiModelProperty(value = "实名状态")
    private Integer realAuthStatus;
    @ApiModelProperty(value = "常驻地址")
    private String resAddress;
    private String entName;
    private Integer entCheckStatus;
    @ApiModelProperty(value = "飞手审核原因")
    private String licCheckReason;
    @ApiModelProperty(value = "电子执照认证提交时间")
    private Date licCreateTime;
    @ApiModelProperty(value = "电子执照认证审核时间")
    private Date licUpdateTime;
    @ApiModelProperty(value = "商务礼仪认证")
    private Integer protocolAuth;
    @ApiModelProperty(value = "电力巡检认证状态，0未认证，1通过，2未通过")
    private Integer electricAuth;
    @ApiModelProperty(value = "航空测绘认证状态，0未认证，1通过，2未通过", hidden = true)
    private Integer aviationAuth;
    @ApiModelProperty(value = "应急保障认证状态，0未认证，1通过，2未通过", hidden = true)
    private Integer emergencyAuth;
    @ApiModelProperty(value = "value = 监察巡检认证状态，0未认证，1通过，2未通过", hidden = true)
    private Integer superviseAuth;
    @ApiModelProperty(value = "通用认证状态，0未认证，1通过，2未通过")
    private Integer universalAuth;
    @ApiModelProperty(value = "油气巡检认证状态，0未认证，1通过，2未通过")
    private Integer oilGasAuth;
    @ApiModelProperty(value = "演示认证状态，0未认证，1通过，2未通过")
    private Integer demoAuth;
    @ApiModelProperty(value = "航空测绘外业状态，0未认证，1通过，2未通过")
    private Integer aviationOutAuth;
    @ApiModelProperty(value = "航空测绘内业状态，0未认证，1通过，2未通过")
    private Integer aviationInAuth;
    @ApiModelProperty(value = "指挥车认证状态，0未认证，1通过，2未通过")
    private Integer commandAuth;
    @ApiModelProperty(value = "天目将软件认证状态，0未认证，1通过，2未通过")
    private Integer tmjAuth;
    @ApiModelProperty(value = "0:无订单状态（空闲） 1:有订单（作业中）")
    private Integer serviceStatus;
    @ApiModelProperty(value = "评分记录")
    private FlyerRecordDTO record;
}

