package com.mmc.payment.entity;

import com.mmc.payment.model.dto.OrderVcuDTO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/6/1 15:55
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class OrderVcuDO implements Serializable {
    private static final long serialVersionUID = 5685858931224789256L;
    private Integer id;
    private Integer orderInfoId;
    private Integer orderRefundId;
    private Integer vcuType;
    private Integer vcuSatus;
    private String imgs;
    private String videoUrl;
    private String remark;
    private Date createTime;

    public OrderVcuDTO buildOrderVcuDTO() {
        return OrderVcuDTO.builder().id(this.id).orderInfoId(this.orderInfoId).vcuType(this.vcuType)
                .vcuSatus(this.vcuSatus)
                .imgs(StringUtils.isBlank(this.imgs) ? null : Arrays.asList(this.imgs.split(",")))
                .remark(this.remark)
                .videoUrl(this.videoUrl).build();
    }
}
