package com.mmc.payment.controller;

import com.mmc.payment.common.BaseController;
import com.mmc.payment.common.ResultBody;
import com.mmc.payment.config.RepeatSubmit;
import com.mmc.payment.model.dto.CashTypeDTO;
import com.mmc.payment.model.dto.PayCashResultDTO;
import com.mmc.payment.model.dto.RepoCashDTO;
import com.mmc.payment.model.dto.RepoWalletDTO;
import com.mmc.payment.model.qo.RepoCashQO;
import com.mmc.payment.model.qo.UserCashQO;
import com.mmc.payment.model.vo.RepoCashVO;
import com.mmc.payment.model.vo.RepoOrderPayVO;
import com.mmc.payment.model.vo.WalletUsersVO;
import com.mmc.payment.service.RepoCashService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;

/**
 * @Author small @Date 2023/5/24 9:53 @Version 1.0
 */
@Api(tags = {"现金管理"})
@RestController
@RequestMapping("/repocash/")
public class RepoCashController extends BaseController {

    @Autowired
    private RepoCashService repoCashService;

    @Autowired
    private StringRedisTemplate stringRedisTemplate;


    @ApiOperation(value = "现金管理列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = RepoWalletDTO.class)})
    @PostMapping("listPagePayManager")
    public ResultBody<RepoWalletDTO> listPagePayManager(HttpServletRequest request, @RequestBody UserCashQO param) {
        return ResultBody.success(repoCashService.listPagePayManager(this.getCurrentAccount(request), param));
    }


    @ApiOperation(value = "余额变更-分页-列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = RepoCashDTO.class)})
    @PostMapping("listPageCash")
    public ResultBody<RepoCashDTO> listPageCash(HttpServletRequest request, @RequestBody RepoCashQO param) {
        return ResultBody.success(repoCashService.listPageRepoCash(this.getCurrentAccount(request), param));
    }


    @ApiOperation(value = "现金类型")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = RepoCashDTO.class)})
    @PostMapping("cashType")
    public ResultBody<CashTypeDTO> cashType() {
        return repoCashService.cashType();
    }


    @ApiOperation(value = "v1.0.1-现金-充值/即扣款")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @RepeatSubmit
    @PostMapping("reqCash")
    public ResultBody reqCash(HttpServletRequest request, @RequestBody RepoCashVO param) {
        return repoCashService.reqCash(this.getCurrentAccount(request), param);
    }


    @ApiOperation(value = "小程序用户生成时,用户钱包中用户同时生成————用于远程，前端不使用")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("walletUsers")
    public ResultBody walletUsers(@RequestBody WalletUsersVO walletUsersVO) {
        return repoCashService.walletUsers(walletUsersVO);
    }


    @ApiOperation(value = "租赁——订单支付")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("orderPayment")
    public ResultBody orderPayment(HttpServletRequest request, @RequestParam String orderNo) {
        return repoCashService.orderPayment(this.getCurrentAccount(request), orderNo);
    }

    @ApiOperation(value = "支付订单-充值扣款")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = PayCashResultDTO.class)})
    @ApiIgnore
    @PostMapping("PayCashOrder")
    public PayCashResultDTO feignPayCashOrder(@RequestBody RepoOrderPayVO orderPay) {
        return repoCashService.payCashOrder(orderPay);
    }

    @ApiIgnore
    @ApiOperation(value = "当前用户剩余的余额")
    @GetMapping("RemainingBalance")
    public BigDecimal RemainingBalance(
            @RequestParam(value = "repoAccountId", required = true) Integer repoAccountId) {
        return repoCashService.RemainingBalance(repoAccountId);
    }

    @ApiIgnore
    @ApiOperation(value = "余额变更-修改备注")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("updateCashRemark")
    public ResultBody updateCashRemark(@RequestParam Integer id, @RequestParam() String remark) {
        repoCashService.updateCashRemark(id, remark);
        return ResultBody.success();
    }


    @ApiIgnore
    @ApiOperation(value = "v1.0.1-Yes现金-手动扣除")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @RepeatSubmit
    @PostMapping("dedCash")
    public ResultBody dedCash(HttpServletRequest request, @RequestBody RepoCashVO param) {
        return repoCashService.dedCash(this.getCurrentAccount(request), param);
    }


    @ApiIgnore
    @ApiOperation(value = "查询退款金额")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = RepoCashDTO.class)})
    @GetMapping("feignRefundInfo")
    public RepoCashDTO feignRefundInfo(@RequestParam String refundNo) {
        return repoCashService.getRefundInfo(refundNo);
    }


    @ApiOperation(value = "退款金额---用户后台内部调用前端不使用")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("amountOfRefund")
    public ResultBody amountOfRefund(HttpServletRequest request, @RequestParam(value = "orderNo") String orderNo,
                                     @RequestParam(value = "actualPay") BigDecimal actualPay,
                                     @RequestParam(value = "repoAccountId") Integer repoAccountId,
                                     @RequestParam(value = "refundNo") String refundNo) {
        return repoCashService.amountOfRefund(this.getCurrentAccount(request), orderNo, actualPay, repoAccountId, refundNo);
    }


}
