package com.mmc.payment.controller;

import com.mmc.payment.common.ResultBody;
import com.mmc.payment.config.AuthHandler;
import com.mmc.payment.jwt.JwtConstant;
import com.mmc.payment.model.dto.BaseAccountDTO;
import com.mmc.payment.model.dto.RepoAccountDTO;
import com.mmc.payment.model.qo.RepoAccountQO;
import com.mmc.payment.service.RepoAccountService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

import javax.servlet.http.HttpServletRequest;

/**
 * @Author small
 * @Date 2023/5/23 18:40
 * @Version 1.0
 */
@Api(tags = {"云仓-账号相关-接口"})
@RestController
@ApiIgnore
@RequestMapping("/repoaccount/")
public class RepoAccountController {

    @Autowired
    private RepoAccountService repoAccountService;

    @Autowired
    private AuthHandler authHandler;

    @ApiOperation(value = "PC端-云仓-消耗管理")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = RepoAccountDTO.class)})
    @PostMapping("listPagePayManager")
    public ResultBody listPagePayManager(HttpServletRequest request, @RequestBody RepoAccountQO param) {
        return ResultBody.success(repoAccountService.listPagePayManager(param, this.getCurrentAccount(request)));
    }

    /**
     * 获取当前登录账号信息
     */
    public BaseAccountDTO getCurrentAccount(HttpServletRequest request) {
        String token = request.getHeader(JwtConstant.TOKENKEY);
        return authHandler.getCurrentAccount(token);
    }


}
