package com.mmc.payment.common;

import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @Author small
 * @Date 2023/5/23 19:19
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.result.ResultBody", description = "请求响应体")
public class ResultBody<T> implements Serializable {
    private static final long serialVersionUID = 6341937455634693363L;

    /**
     * 响应代码
     */
    @ApiModelProperty(value = "响应代码")
    private String code;

    /**
     * 响应消息
     */
    @ApiModelProperty(value = "响应消息")
    private String message;

    /**
     * 响应结果
     */
    @ApiModelProperty(value = "响应结果")
    private T result;

    public ResultBody(BaseErrorInfoInterface errorInfo) {
        this.code = errorInfo.getResultCode();
        this.message = errorInfo.getResultMsg();
    }

    /**
     * 成功
     *
     * @return
     */
    public static ResultBody success() {
        return success(null);
    }

    /**
     * 成功
     *
     * @param data
     * @return
     */
    public static <T> ResultBody success(T data) {
        ResultBody rb = new ResultBody();
        rb.setCode(ResultEnum.SUCCESS.getResultCode());
        rb.setMessage(ResultEnum.SUCCESS.getResultMsg());
        rb.setResult(data);
        return rb;
    }

    /**
     * 成功
     *
     * **/
    public static ResultBody success1(ResultEnum enums){
        ResultBody rb = new ResultBody();
        rb.setCode("200");
        rb.setMessage(enums.getResultMsg());
        rb.setResult(null);
        return rb;
    }


    public void buildSuccess() {
        this.setCode(ResultEnum.SUCCESS.getResultCode());
        this.setMessage(ResultEnum.SUCCESS.getResultMsg());
    }

    /**
     * 失败
     */
    public static ResultBody error(BaseErrorInfoInterface errorInfo) {
        ResultBody rb = new ResultBody();
        rb.setCode(errorInfo.getResultCode());
        rb.setMessage(errorInfo.getResultMsg());
        rb.setResult(null);
        return rb;
    }

    /**
     * 失败
     */
    public static ResultBody error(String code, String message) {
        ResultBody rb = new ResultBody();
        rb.setCode(code);
        rb.setMessage(message);
        rb.setResult(null);
        return rb;
    }

    /**
     * 失败
     */
    public static ResultBody error(ResultEnum enums) {
        ResultBody rb = new ResultBody();
        rb.setCode(enums.getResultCode());
        rb.setMessage(enums.getResultMsg());
        rb.setResult(null);
        return rb;
    }

    /**
     * 失败
     */
    public static ResultBody error(String message) {
        ResultBody rb = new ResultBody();
        rb.setCode("-1");
        rb.setMessage(message);
        rb.setResult(null);
        return rb;
    }

    /**
     * 失败
     */
    public static ResultBody error(ResultEnum enums, Object data) {
        ResultBody rb = new ResultBody();
        rb.setCode(enums.getResultCode());
        rb.setMessage(enums.getResultMsg());
        rb.setResult(data);
        return rb;
    }

    public static boolean isSuccess(ResultBody res) {
        return res.getCode().equals(ResultEnum.SUCCESS.getResultCode());
    }

    @Override
    public String toString() {
        return JSONObject.toJSONString(this);
    }
}
