package com.mmc.payment.common;

import java.math.BigDecimal;

/**
 * @Author small
 * @Date 2023/5/24 10:15
 * @Version 1.0
 */
public class AmtUtil {
    private static final BigDecimal minCashCost = BigDecimal.valueOf(-99999999.99);// -9999万9999元.99
    private static final BigDecimal maxCashCost = BigDecimal.valueOf(99999999.99);// 9999万9999元.99

    private static final BigDecimal minRepeatCost = BigDecimal.ZERO;// 0
    private static final BigDecimal maxRepeatCost = BigDecimal.valueOf(99999999.99);// 9999万9999元.99

    public static final BigDecimal REBATE_RATE = (BigDecimal.valueOf(0.01).setScale(2, BigDecimal.ROUND_DOWN));// 返利的百分比

    /**
     * 变更-金额范围
     *
     * @param amtPaid
     * @return
     */
    public static boolean vertifyAmt(BigDecimal amtPaid) {
        return (amtPaid != null && (amtPaid.compareTo(minCashCost) >= 0) && (amtPaid.compareTo(maxCashCost) <= 0));
    }

    /**
     * 还款-金额范围
     *
     * @param amtPaid
     * @return
     */
    public static boolean vertifyRepeatAmt(BigDecimal amtPaid) {
        return (amtPaid != null && (amtPaid.compareTo(minRepeatCost) > 0) && (amtPaid.compareTo(maxRepeatCost) <= 0));
    }

    public static boolean vertifyRepoAmt(BigDecimal amtPaid) {
        return (amtPaid != null && (amtPaid.compareTo(BigDecimal.ZERO) > 0) && (amtPaid.compareTo(maxCashCost) <= 0));
    }
}
