package com.mmc.payment.service.Impl;

import com.mmc.payment.common.result.PageResult;
import com.mmc.payment.dao.RepoAccountDao;
import com.mmc.payment.entity.repo.RepoWalletDO;
import com.mmc.payment.model.dto.repo.RepoWalletDTO;
import com.mmc.payment.model.dto.user.BaseAccountDTO;
import com.mmc.payment.model.dto.user.RepoAccountDTO;
import com.mmc.payment.model.qo.RepoAccountQO;
import com.mmc.payment.service.RepoAccountService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Author small @Date 2023/5/23 19:12 @Version 1.0
 */
@Service
public class RepoAccountServiceImpl implements RepoAccountService {
    @Autowired
    private RepoAccountDao repoAccountDao;

    @Override
    public PageResult listPagePayManager(RepoAccountQO param, BaseAccountDTO cuser) {
    /*if(!cuser.isManage()){
        param.setCompanys(cuser.getCompanyInfo().getCompanys());
    }*/
        int count = repoAccountDao.countPagePayManager(param);
        if (count == 0) {
            return PageResult.buildPage(param.getPageNo(), param.getPageSize(), count);
        }
        Integer pageNo = param.getPageNo();
        param.buildCurrentPage();
        List<RepoAccountDTO> data =
                repoAccountDao.listPagePayManager(param).stream()
                        .map(
                                d -> {
                                    d.buildName();
                                    return d.buildRepoAccountDTO();
                                })
                        .collect(Collectors.toList());
        List<Integer> accountIds =
                data.stream().map(RepoAccountDTO::getId).collect(Collectors.toList());
        param.setAccountIds(accountIds);
        // List<RepoWalletDTO> wallets = repoPayServletClient.feignListWalletInfo(param);
        List<RepoWalletDTO> wallets = listWalletInfo(param);
        Map<Integer, RepoWalletDTO> mapWallet =
                wallets.stream()
                        .collect(
                                Collectors.toMap(
                                        RepoWalletDTO::getRepoAccountId, wallet -> wallet, (k1, k2) -> k2));
        for (RepoAccountDTO ac : data) {
            if (mapWallet.containsKey(ac.getId())) {
                ac.setCashAmt(mapWallet.get(ac.getId()).getCashAmt());
                ac.setRemark(mapWallet.get(ac.getId()).getRemark());
            }
        }
        return PageResult.buildPage(pageNo, param.getPageSize(), count, data);
    }

    public List<RepoWalletDTO> listWalletInfo(RepoAccountQO param) {
        if (CollectionUtils.isEmpty(param.getAccountIds())) {
            return java.util.Collections.emptyList();
        }
        List<RepoWalletDO> wallets = repoAccountDao.listWalletInfo(param);
        return wallets.stream()
                .map(
                        d -> {
                            return d.buildRepoWalletDTO();
                        })
                .collect(Collectors.toList());
    }
}
