package com.mmc.payment.entity.flyer;

import com.mmc.payment.common.FlyerAccountType;
import com.mmc.payment.model.dto.flyer.FlyerAccountDTO;
import com.mmc.payment.model.dto.flyer.FlyerInfoDTO;
import com.mmc.payment.model.dto.flyer.FlyerRcdTeamDTO;
import com.mmc.payment.model.vo.flyer.FlyerAccountVO;
import com.mmc.payment.model.vo.flyer.FlyerWorkStatusVO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;

/**
 * @Author small
 * @Date 2023/5/29 16:11
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class FlyerAccountDO implements Serializable {
    private static final long serialVersionUID = 6990172418648675316L;
    private Integer id;
    private String uid;
    private String accountName;
    private String phoneNum;
    private Integer accountType;
    private Integer realAuthStatus;
    private Integer entAuthStatus;
    private Integer workStatus;
    private Integer serviceStatus;
    private String openId;
    private String unionId;
    private String nickName;
    private String resAddress;
    private String headerImg;
    private Double lon;
    private Double lat;
    private String ports;
    private String remark;
    private Integer deleted;
    private Date createTime;
    private Date updateTime;
    private Integer sale;
    private Integer white;
    private Integer source;

    private FlyerAccountDO rcdFlyer;

    /**
     * 辅助字段-start
     *
     * @return
     */
    private String entName;
    private Integer licStatus;
    private FlyerEntInfoDO entInfo;
    private Date rcdCreateTime;
    private String rcdRemark;

    private String flyerName;
    private Integer protocolAuth;
    private Integer electricAuth;
    private Integer aviationAuth;
    private Integer emergencyAuth;
    private Integer superviseAuth;
    private Integer universalAuth;
    private Integer oilGasAuth;
    private Integer demoAuth;
    private Integer aviationOutAuth;
    private Integer aviationInAuth;
    private Integer commandAuth;
    private Integer tmjAuth;

    private String xeUserId;


    public FlyerAccountDO(FlyerWorkStatusVO flyerWorkStatusVO) {
        this.id = flyerWorkStatusVO.getId();
        this.resAddress = flyerWorkStatusVO.getResAddress();
        this.lon = flyerWorkStatusVO.getLon();
        this.lat = flyerWorkStatusVO.getLat();
        this.workStatus = flyerWorkStatusVO.getWorkStatus();
    }

    /**
     * 辅助字段-end
     *
     * @return
     */

    public FlyerAccountDTO builderFlyerAccountDTO() {
        Integer white = 0;
        if (rcdFlyer != null && rcdFlyer.getSale() == 1) {
            white = 1;
        }
        return FlyerAccountDTO.builder().id(this.id).uid(this.uid).accountName(this.accountName).phoneNum(this.phoneNum).accountType(this.accountType)
                .realAuthStatus(this.realAuthStatus).entAuthStatus(this.entAuthStatus).workStatus(this.workStatus)
                .nickName(this.nickName).serviceStatus(this.serviceStatus).unionId(this.unionId)
                .headerImg(this.headerImg).lon(this.lon).lat(this.lat).remark(this.remark).deleted(this.deleted).createTime(this.createTime)
                .updateTime(this.updateTime).resAddress(this.resAddress).entName(this.entName).licStatus(this.licStatus)
                .ports(StringUtils.isEmpty(this.ports) ? null
                        : new HashSet<String>(Arrays.asList(this.ports.split(","))))
                .entInfo(this.entInfo == null ? null : this.entInfo.buildFlyerEntInfoDTO()).openId(this.openId)
                .sale(this.sale)
                .rcdFlyerAccountId(this.rcdFlyer == null ? null : this.rcdFlyer.getId())
                .rcdUid(this.rcdFlyer == null ? null : this.rcdFlyer.getUid())
                .rcdAccountName(this.rcdFlyer == null ? null : this.rcdFlyer.getAccountName())
                .rcdNickName(this.rcdFlyer == null ? null : this.rcdFlyer.getNickName()).white(white).source(this.source).build();
    }

    public FlyerRcdTeamDTO builderFlyerRcdTeamDTO() {
        return FlyerRcdTeamDTO.builder().FlyerAccountName(this.accountName).id(this.id).accountType(this.accountType)
                .realAuthStatus(this.realAuthStatus).entAuthStatus(this.entAuthStatus).createTime(this.rcdCreateTime)
                .phoneNum(this.phoneNum).nickName(this.nickName).remark(this.rcdRemark).uid(this.uid).build();
    }

    public FlyerAccountDO(FlyerAccountVO flyerAccountVO) {
        this.id = flyerAccountVO.getId();
        this.uid = flyerAccountVO.getUid();
        this.accountName = flyerAccountVO.getAccountName();
        this.accountType = flyerAccountVO.getAccountType();
        this.phoneNum = flyerAccountVO.getPhoneNum();
        this.realAuthStatus = flyerAccountVO.getRealAuthStatus();
        this.entAuthStatus = flyerAccountVO.getEntAuthStatus();
        this.workStatus = flyerAccountVO.getWorkStatus();
        this.nickName = flyerAccountVO.getNickName();
        this.resAddress = flyerAccountVO.getResAddress();
        this.headerImg = flyerAccountVO.getHeaderImg();
        this.lon = flyerAccountVO.getLon();
        this.lat = flyerAccountVO.getLat();
        this.remark = flyerAccountVO.getRemark();
        this.deleted = flyerAccountVO.getDeleted();
    }

    public FlyerInfoDTO buildFlyerInfoDTO() {
        return FlyerInfoDTO.builder().id(this.id).flyerName(this.flyerName).licStatus(this.licStatus).phoneNum(this.phoneNum)
                .protocolAuth(this.protocolAuth).electricAuth(this.electricAuth).aviationAuth(this.aviationAuth)
                .emergencyAuth(this.emergencyAuth).superviseAuth(this.superviseAuth).universalAuth(this.universalAuth)
                .oilGasAuth(this.oilGasAuth).demoAuth(this.demoAuth).aviationOutAuth(this.aviationOutAuth)
                .aviationInAuth(this.aviationOutAuth).commandAuth(this.commandAuth).tmjAuth(this.tmjAuth).build();
    }

    /**
     * 是否为飞手机构用户
     *
     * @return
     */
    public boolean checkFlyerEnt() {
        return (FlyerAccountType.JG.getCode().toString().equals(this.accountType.toString()));
    }

    /**
     * 是否为飞手个人用户
     *
     * @return
     */
    public boolean checkFlyer() {
        return (FlyerAccountType.GR.getCode().toString().equals(this.accountType.toString()));
    }

    /**
     * 是否为普通用户
     *
     * @return
     */
    public boolean checkUsual() {
        return (FlyerAccountType.PT.getCode().toString().equals(this.accountType.toString()));
    }
}
