package com.mmc.payment.controller;

import com.alibaba.fastjson2.JSONObject;
import com.mmc.payment.common.result.ResultEnum;
import com.mmc.payment.exception.BizException;
import com.mmc.payment.model.dto.user.LoginSuccessDTO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;

import javax.servlet.http.HttpServletRequest;

/**
 * @author: zj
 * @Date: 2023/5/25 18:11
 */
public abstract class BaseController {

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    /**
     * 使用token从redis获取用户信息
     *
     * @param request
     * @return
     */
    public LoginSuccessDTO getUserLoginInfoFromRedis(HttpServletRequest request) {
        String token = request.getHeader("token");
        if (StringUtils.isBlank(token)) {
            throw new BizException(ResultEnum.LOGIN_ACCOUNT_STATUS_ERROR);
        }
        String json = stringRedisTemplate.opsForValue().get(token);
        if (StringUtils.isBlank(json)) {
            throw new BizException(ResultEnum.LOGIN_ACCOUNT_STATUS_ERROR);
        }
        LoginSuccessDTO loginSuccessDTO = JSONObject.parseObject(json, LoginSuccessDTO.class);
        return loginSuccessDTO;
    }
}
